/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.goals;

import com.majruszs_difficulty.entities.CreeperlingEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.server.ServerWorld;

public class CreeperExplodeWallsGoal
extends Goal {
    private final CreeperEntity creeper;
    private final double maximumStartDistance = 19.0;
    private final double maximumExplodeDistance = 49.0;
    private final double offset = 10.0;
    private LivingEntity attackTarget;

    public CreeperExplodeWallsGoal(CreeperEntity creeper) {
        this.creeper = creeper;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        PlayerEntity target = this.getNearestPlayer(this.creeper);
        return this.creeper.func_70832_p() > 0 || target != null && this.creeper.func_70068_e((Entity)target) < this.maximumStartDistance * this.getDistanceMultiplier();
    }

    public void func_75249_e() {
        this.creeper.func_70661_as().func_75499_g();
        this.attackTarget = this.getNearestPlayer(this.creeper);
    }

    public void func_75251_c() {
        this.attackTarget = null;
    }

    public void func_75246_d() {
        if (this.attackTarget == null || this.creeper.func_70068_e((Entity)this.attackTarget) > this.maximumExplodeDistance * this.getDistanceMultiplier()) {
            this.creeper.func_70829_a(-1);
        } else {
            this.creeper.func_70829_a(1);
        }
    }

    private double getDistanceMultiplier() {
        return this.creeper instanceof CreeperlingEntity ? 0.6 : 1.0;
    }

    @Nullable
    private PlayerEntity getNearestPlayer(CreeperEntity creeper) {
        if (!(creeper.field_70170_p instanceof ServerWorld)) {
            return null;
        }
        ServerWorld world = (ServerWorld)creeper.field_70170_p;
        double x = creeper.func_226277_ct_();
        double y = creeper.func_226278_cu_();
        double z = creeper.func_226281_cx_();
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(x - this.offset, y - this.offset, z - this.offset, x + this.offset, y + this.offset, z + this.offset);
        PlayerEntity nearestPlayer = null;
        for (PlayerEntity player : world.func_217357_a(PlayerEntity.class, axisAlignedBB)) {
            if (player.field_71075_bZ.field_75098_d || nearestPlayer != null && !(creeper.func_70068_e((Entity)player) < creeper.func_70068_e((Entity)nearestPlayer))) continue;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }
}

