/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.goals;

import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;

public class UndeadAttackPositionGoal
extends Goal {
    protected final MobEntity undead;
    protected final BlockPos attackPosition;
    protected final double speedModifier;
    protected final float maxDistanceFromPosition;
    protected final float stopDistance;
    private final PathNavigator navigation;
    protected int ticksToRecalculatePath;

    public UndeadAttackPositionGoal(MobEntity undead, BlockPos attackPosition, double speedModifier, float maxDistanceFromPosition, float stopDistance) {
        this.undead = undead;
        this.navigation = undead.func_70661_as();
        this.attackPosition = attackPosition;
        this.speedModifier = speedModifier;
        this.maxDistanceFromPosition = maxDistanceFromPosition;
        this.stopDistance = stopDistance;
        this.ticksToRecalculatePath = 0;
    }

    public boolean func_75250_a() {
        return !this.isInRadius() && !this.hasAnyTarget();
    }

    public boolean func_75253_b() {
        return !this.isInRadius() && !this.navigation.func_75500_f() && !this.hasAnyTarget();
    }

    public void func_75249_e() {
        this.ticksToRecalculatePath = 0;
    }

    public void func_75246_d() {
        if (--this.ticksToRecalculatePath > 0) {
            return;
        }
        this.ticksToRecalculatePath = 10;
        this.navigation.func_75492_a((double)this.attackPosition.func_177958_n(), (double)this.attackPosition.func_177956_o(), (double)this.attackPosition.func_177952_p(), this.speedModifier);
    }

    protected boolean isInRadius() {
        return this.getDistanceToAttackPosition() < (double)this.maxDistanceFromPosition;
    }

    protected boolean hasAnyTarget() {
        return this.undead.func_70638_az() != null || this.undead.func_70643_av() != null;
    }

    protected double getDistanceToAttackPosition() {
        return Math.sqrt(Math.pow(this.undead.func_226277_ct_() - (double)this.attackPosition.func_177958_n(), 2.0) + Math.pow(this.undead.func_226281_cx_() - (double)this.attackPosition.func_177952_p(), 2.0));
    }
}

