/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.items.CustomArmorMaterial;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EndArmorItem
extends ArmorItem {
    private static final String ARMOR_TICK_TAG = "EndArmorTickCounter";

    public EndArmorItem(EquipmentSlotType slot) {
        super((IArmorMaterial)CustomArmorMaterial.END, slot, new Item.Properties().func_200916_a(Instances.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON).func_234689_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        MajruszsHelper.addExtraTooltipIfDisabled(tooltip, Instances.END_SHARD_ORE.isEnabled());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        CompoundNBT data = entity.getPersistentData();
        data.func_74768_a(ARMOR_TICK_TAG, (data.func_74762_e(ARMOR_TICK_TAG) + 1) % 320);
        String register = "textures/models/armor/end_layer_";
        register = register + (slot == EquipmentSlotType.LEGS ? "2" : "1") + "_";
        register = register + "" + (1 + data.func_74762_e(ARMOR_TICK_TAG) / 80) + ".png";
        ResourceLocation textureLocation = MajruszsDifficulty.getLocation(register);
        return textureLocation.toString();
    }
}

