/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.items.EndArmorItem;
import com.mlib.TimeConverter;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EndLeggingsItem
extends EndArmorItem {
    private static final String ARMOR_TAG = "EndLeggingsArmorTag";
    private static final String ARMOR_BONUS_TAG = "EndLeggingsArmorBonus";
    private static final String ARMOR_COUNTER_TAG = "EndLeggingsCounter";
    protected static final AttributeHandler ARMOR_ATTRIBUTE = new AttributeHandler("4290dea8-ef26-40bc-8f7f-28912d31329a", "EndLeggingsArmorBonus", Attributes.field_233826_i_, AttributeModifier.Operation.ADDITION);
    protected final ConfigGroup configGroup = new ConfigGroup("EndLeggings", "Config for End Leggings ability.");
    protected final DoubleConfig armorBonus;

    public EndLeggingsItem() {
        super(EquipmentSlotType.LEGS);
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)this.configGroup);
        String comment = "Armor bonus for every enchantment level.";
        this.armorBonus = new DoubleConfig("armor_bonus", comment, false, 0.2, 0.0, 10.0);
        this.configGroup.addConfig((IConfig)this.armorBonus);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        CompoundNBT tag = itemStack.func_190925_c(ARMOR_TAG);
        double bonus = tag.func_74769_h(ARMOR_BONUS_TAG);
        if (bonus > 0.0) {
            tooltip.add((ITextComponent)this.getArmorBonusTooltip(bonus));
        }
    }

    @SubscribeEvent
    public static void applyArmorBonus(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        double armorBonus = EndLeggingsItem.calculateEnchantmentBonus(entity);
        ItemStack leggingsItemStack = entity.func_184582_a(EquipmentSlotType.LEGS);
        boolean hasEndLeggings = leggingsItemStack.func_77973_b() instanceof EndLeggingsItem;
        EndLeggingsItem.updateLeggingsTag(entity.func_184582_a(EquipmentSlotType.LEGS), armorBonus);
        ARMOR_ATTRIBUTE.setValueAndApply(entity, hasEndLeggings ? armorBonus : 0.0);
    }

    @SubscribeEvent
    public static void updateArmorBonusOnAllItems(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity.field_70170_p instanceof ServerWorld) || !(entity instanceof PlayerEntity)) {
            return;
        }
        CompoundNBT data = entity.getPersistentData();
        int counter = (data.func_74762_e(ARMOR_COUNTER_TAG) + 1) % TimeConverter.secondsToTicks((double)1.0);
        data.func_74768_a(ARMOR_COUNTER_TAG, counter);
        if (counter == 0) {
            for (ItemStack itemStack : ((PlayerEntity)entity).field_71071_by.field_70462_a) {
                EndLeggingsItem.updateLeggingsTag(itemStack, 0.0);
            }
        }
    }

    private static double calculateEnchantmentBonus(LivingEntity entity) {
        double armorBonus = Instances.END_LEGGINGS_ITEM.armorBonus.get();
        int enchantmentLevelSum = 0;
        ItemStack leggings = entity.func_184582_a(EquipmentSlotType.LEGS);
        if (leggings.func_77973_b() instanceof EndLeggingsItem) {
            for (ItemStack armorPiece : entity.func_184193_aE()) {
                if (armorPiece.func_190926_b()) continue;
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)armorPiece);
                for (Map.Entry enchantment : enchantments.entrySet()) {
                    enchantmentLevelSum += ((Integer)enchantment.getValue()).intValue();
                }
            }
        }
        return (double)enchantmentLevelSum * armorBonus;
    }

    private static void updateLeggingsTag(ItemStack leggings, double armorBonus) {
        if (leggings.func_190926_b() || !(leggings.func_77973_b() instanceof EndLeggingsItem)) {
            return;
        }
        CompoundNBT tag = leggings.func_190925_c(ARMOR_TAG);
        tag.func_74780_a(ARMOR_BONUS_TAG, armorBonus);
        leggings.func_77983_a(ARMOR_TAG, (INBT)tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    private IFormattableTextComponent getArmorBonusTooltip(double armorBonus) {
        IFormattableTextComponent text = new StringTextComponent("+").func_240702_b_(armorBonus + " ");
        return text.func_230529_a_((ITextComponent)new TranslationTextComponent("item.majruszs_difficulty.end_leggings.item_tooltip")).func_240699_a_(TextFormatting.GRAY);
    }
}

