/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.google.common.collect.ImmutableMultimap;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.items.AttributeArmorItem;
import com.majruszs_difficulty.items.CustomArmorMaterial;
import com.majruszs_difficulty.models.HermesArmorModel;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HermesBootsItem
extends AttributeArmorItem {
    protected final DoubleConfig movementSpeedBonus;
    protected final ConfigGroup configGroup;

    public HermesBootsItem() {
        super(CustomArmorMaterial.HERMES, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(Instances.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON));
        String comment = "Movement speed extra multiplier. (requires game/world restart!)";
        this.movementSpeedBonus = new DoubleConfig("movement_speed_bonus", comment, true, 0.25, 0.0, 5.0);
        this.configGroup = new ConfigGroup("HermesBoots", "Hermes Boots item configuration.");
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)this.configGroup);
        this.configGroup.addConfig((IConfig)this.movementSpeedBonus);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        ResourceLocation textureLocation = MajruszsDifficulty.getLocation("textures/models/armor/hermes_layer.png");
        return textureLocation.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <ArmorModel extends BipedModel<?>> ArmorModel getArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlotType armorSlot, ArmorModel defaultModel) {
        HermesArmorModel model = new HermesArmorModel();
        model.field_78116_c.field_78806_j = armorSlot == EquipmentSlotType.HEAD;
        model.field_178720_f.field_78806_j = false;
        model.field_78115_e.field_78806_j = armorSlot == EquipmentSlotType.CHEST;
        model.field_178724_i.field_78806_j = false;
        model.field_178723_h.field_78806_j = false;
        model.field_178721_j.field_78806_j = armorSlot == EquipmentSlotType.FEET;
        model.field_178722_k.field_78806_j = armorSlot == EquipmentSlotType.FEET;
        model.field_217114_e = defaultModel.field_217114_e;
        model.field_217113_d = defaultModel.field_217113_d;
        model.field_228270_o_ = defaultModel.field_228270_o_;
        model.field_187076_m = defaultModel.field_187076_m;
        model.field_187075_l = defaultModel.field_187075_l;
        return (ArmorModel)((Object)model);
    }

    @Override
    protected void updateAttributes(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(UUID.fromString("dbe472cb-df52-44ab-ab38-01b00e24f649"), "HermesBootsMovementSpeedBonus", this.movementSpeedBonus.get().doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE));
    }
}

