/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.events.TreasureBagOpenedEvent;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TreasureBagItem
extends Item {
    protected static final ConfigGroup CONFIG_GROUP = new ConfigGroup("TreasureBag", "Configuration for treasure bags.");
    private static final String TOOLTIP_TRANSLATION_KEY = "majruszs_difficulty.treasure_bag.item_tooltip";
    private final ResourceLocation lootTableLocation;
    private final String id;
    private final AvailabilityConfig availability;

    public TreasureBagItem(String id, String entityNameForConfiguration) {
        super(new Item.Properties().func_200917_a(16).func_200916_a(Instances.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON));
        this.lootTableLocation = new ResourceLocation("majruszs_difficulty", "gameplay/" + id + "_treasure_loot");
        this.id = id;
        this.availability = new AvailabilityConfig(id, TreasureBagItem.getComment(entityNameForConfiguration), false, true);
        CONFIG_GROUP.addConfig((IConfig)this.availability);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            if (player instanceof ServerPlayerEntity) {
                this.handleStatistics((ServerPlayerEntity)player);
            }
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 1.0f, 0.9f);
            if (this.availability.isEnabled()) {
                List<ItemStack> loot = this.generateLoot(player);
                MinecraftForge.EVENT_BUS.post((Event)new TreasureBagOpenedEvent(player, this, loot));
                for (ItemStack reward : loot) {
                    if (player.func_213365_e(reward)) {
                        player.field_71071_by.func_70441_a(reward);
                        continue;
                    }
                    world.func_217376_c((Entity)new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), reward));
                }
            }
        }
        return ActionResult.func_233538_a_((Object)itemStack, (boolean)world.func_201670_d());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        MajruszsHelper.addExtraTooltipIfDisabled(tooltip, this.availability.isEnabled());
        MajruszsHelper.addAdvancedTooltip(tooltip, flag, TOOLTIP_TRANSLATION_KEY);
    }

    protected static LootContext generateLootContext(PlayerEntity player) {
        LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerWorld)player.func_130014_f_());
        lootContextBuilder.func_216015_a(LootParameters.field_237457_g_, (Object)player.func_213303_ch());
        lootContextBuilder.func_216015_a(LootParameters.field_216281_a, (Object)player);
        return lootContextBuilder.func_216022_a(LootParameterSets.field_216264_e);
    }

    private static String getComment(String treasureBagSourceName) {
        return "Is treasure bag from " + treasureBagSourceName + " available in survival mode?";
    }

    public RegistryObject<TreasureBagItem> register() {
        return RegistryHandler.ITEMS.register(this.id + "_treasure_bag", () -> this);
    }

    public boolean isAvailable() {
        return this.availability.isEnabled();
    }

    protected List<ItemStack> generateLoot(PlayerEntity player) {
        LootTable lootTable = this.getLootTable();
        return lootTable.func_216113_a(TreasureBagItem.generateLootContext(player));
    }

    protected LootTable getLootTable() {
        return ServerLifecycleHooks.getCurrentServer().func_200249_aQ().func_186521_a(this.lootTableLocation);
    }

    protected void handleStatistics(ServerPlayerEntity player) {
        Stat statistic = Stats.field_75929_E.func_199076_b((Object)this);
        ServerStatisticsManager statisticsManager = player.func_147099_x();
        player.func_71029_a(statistic);
        Instances.TREASURE_BAG_TRIGGER.trigger(player, this, statisticsManager.func_77444_a(statistic));
    }

    static {
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)CONFIG_GROUP);
    }
}

