/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.loot_modifiers;

import com.google.gson.JsonObject;
import com.majruszs_difficulty.features.treasure_bag.TreasureBagManager;
import com.majruszs_difficulty.items.TreasureBagItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AddTreasureBagsToLoot
extends LootModifier {
    public AddTreasureBagsToLoot(ILootCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        DamageSource damageSource = (DamageSource)context.func_216031_c(LootParameters.field_216283_c);
        if (entity == null || damageSource == null) {
            return generatedLoot;
        }
        TreasureBagItem treasureBag = TreasureBagManager.getTreasureBag(entity.func_200600_R());
        if (treasureBag == null || !(entity instanceof LivingEntity) || !treasureBag.isAvailable()) {
            return generatedLoot;
        }
        if (TreasureBagManager.rewardAllPlayers((LivingEntity)entity) && TreasureBagManager.shouldReplaceLoot(entity.func_200600_R())) {
            generatedLoot.clear();
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddTreasureBagsToLoot> {
        public AddTreasureBagsToLoot read(ResourceLocation name, JsonObject object, ILootCondition[] conditions) {
            return new AddTreasureBagsToLoot(conditions);
        }

        public JsonObject write(AddTreasureBagsToLoot instance) {
            return null;
        }
    }
}

