/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.renderers;

import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.majruszs_difficulty.models.CreeperlingModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreeperlingRenderer
extends MobRenderer<CreeperlingEntity, CreeperlingModel<CreeperlingEntity>> {
    private static final ResourceLocation CREEPERLING_TEXTURES = MajruszsDifficulty.getLocation("textures/entity/creeperling.png");

    public CreeperlingRenderer(EntityRendererManager renderManager) {
        super(renderManager, new CreeperlingModel(), 0.25f);
    }

    protected float getOverlayProgress(CreeperlingEntity creeperling, float partialTicks) {
        float f = creeperling.func_70831_j(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : MathHelper.func_76131_a((float)f, (float)0.5f, (float)1.0f);
    }

    protected void preRenderCallback(CreeperlingEntity creeperling, MatrixStack matrixStack, float partialTickTime) {
        float f = creeperling.func_70831_j(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        matrixStack.func_227862_a_(f2, f3, f2);
    }

    public ResourceLocation getEntityTexture(CreeperlingEntity entity) {
        return CREEPERLING_TEXTURES;
    }
}

