/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.items.BandageItem;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class BandageTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = MajruszsDifficulty.getLocation("bandage_used");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public Instance deserializeTrigger(JsonObject jsonObject, EntityPredicate.AndPredicate predicate, ConditionArrayParser conditions) {
        JsonElement bandageID = jsonObject.get("bandage_id");
        JsonElement usedOnOneself = jsonObject.get("used_on_oneself");
        return new Instance(predicate, bandageID.getAsString(), usedOnOneself.getAsBoolean());
    }

    public void trigger(ServerPlayerEntity player, BandageItem item, boolean usedOnOneself) {
        this.func_235959_a_(player, instance -> instance.test(item, usedOnOneself));
    }

    public static class Instance
    extends CriterionInstance {
        private final String bandageID;
        private final boolean usedOnOneself;

        public Instance(EntityPredicate.AndPredicate predicate, String bandageID, boolean usedOnOneself) {
            super(ID, predicate);
            this.bandageID = bandageID;
            this.usedOnOneself = usedOnOneself;
        }

        public JsonObject func_230240_a_(ConditionArraySerializer conditions) {
            JsonObject jsonObject = super.func_230240_a_(conditions);
            jsonObject.addProperty("bandage_id", this.bandageID);
            jsonObject.addProperty("used_on_oneself", Boolean.valueOf(this.usedOnOneself));
            return jsonObject;
        }

        public boolean test(BandageItem item, boolean usedOnOneself) {
            return item.getRegistryName() != null && usedOnOneself == this.usedOnOneself && item.getRegistryName().toString().equals(this.bandageID);
        }
    }
}

