/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.items.TreasureBagItem;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class TreasureBagTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = MajruszsDifficulty.getLocation("treasure_bag_opened");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public Instance deserializeTrigger(JsonObject jsonObject, EntityPredicate.AndPredicate predicate, ConditionArrayParser conditions) {
        JsonElement bagID = jsonObject.get("bag_id");
        JsonElement amountOfBags = jsonObject.get("amount");
        return new Instance(predicate, bagID.getAsString(), amountOfBags.getAsInt());
    }

    public void trigger(ServerPlayerEntity player, TreasureBagItem item, int amountOfBags) {
        this.func_235959_a_(player, instance -> instance.test(item, amountOfBags));
    }

    public static class Instance
    extends CriterionInstance {
        private final String bagID;
        private final int amountOfBags;

        public Instance(EntityPredicate.AndPredicate predicate, String bagID, int amountOfBags) {
            super(ID, predicate);
            this.bagID = bagID;
            this.amountOfBags = amountOfBags;
        }

        public JsonObject func_230240_a_(ConditionArraySerializer conditions) {
            JsonObject jsonObject = super.func_230240_a_(conditions);
            jsonObject.addProperty("bag_id", this.bagID);
            jsonObject.addProperty("amount", (Number)this.amountOfBags);
            return jsonObject;
        }

        public boolean test(TreasureBagItem item, int amountOfBags) {
            return item.getRegistryName() != null && amountOfBags >= this.amountOfBags && item.getRegistryName().toString().equals(this.bagID);
        }
    }
}

