/*
 * Decompiled with CFR 0.152.
 */
package com.mlib;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class WorldHelper {
    public static boolean isEntityIn(Entity entity, RegistryKey<World> worldRegistryKey) {
        return entity.field_70170_p.func_234923_W_() == worldRegistryKey;
    }

    public static DifficultyInstance getDifficultyInstance(Entity entity) {
        return entity.field_70170_p.func_175649_E(new BlockPos(entity.func_213303_ch()));
    }

    public static double getRegionalDifficulty(Entity entity) {
        DifficultyInstance difficultyInstance = WorldHelper.getDifficultyInstance(entity);
        return difficultyInstance.func_180168_b();
    }

    public static double getClampedRegionalDifficulty(Entity entity) {
        DifficultyInstance difficultyInstance = WorldHelper.getDifficultyInstance(entity);
        return difficultyInstance.func_180170_c();
    }

    public static boolean isEntityOutside(Entity entity) {
        World world = entity.field_70170_p;
        BlockPos entityPosition = new BlockPos(entity.func_213303_ch());
        return world.func_226660_f_(entityPosition);
    }

    public static boolean isRainingAtEntityBiome(Entity entity) {
        World world = entity.field_70170_p;
        BlockPos entityPosition = new BlockPos(entity.func_213303_ch());
        Biome biome = world.func_226691_t_(entityPosition);
        return world.func_72896_J() && biome.func_201851_b() == Biome.RainType.RAIN;
    }

    public static boolean isEntityOutsideWhenItIsRaining(Entity entity) {
        return WorldHelper.isEntityOutside(entity) && WorldHelper.isRainingAtEntityBiome(entity);
    }

    public static boolean isEntityOutsideDuringTheDay(Entity entity) {
        return WorldHelper.isEntityOutside(entity) && entity.field_70170_p.func_72935_r();
    }

    public static boolean isEntityOutsideDuringTheNight(Entity entity) {
        return WorldHelper.isEntityOutside(entity) && entity.field_70170_p.func_226690_K_();
    }

    @Nullable
    public static ServerWorld getServerWorldFromEntity(Entity entity) {
        return entity.field_70170_p instanceof ServerWorld ? (ServerWorld)entity.field_70170_p : null;
    }

    public static BlockPos getSpawnPosition(ServerPlayerEntity player, ServerWorld world) {
        Optional temporaryPosition;
        BlockPos position = player.func_241140_K_();
        Optional<BlockPos> spawnPosition = Optional.empty();
        if (position != null && (temporaryPosition = ServerPlayerEntity.func_242374_a((ServerWorld)world, (BlockPos)position, (float)player.func_242109_L(), (boolean)player.func_241142_M_(), (boolean)true)).isPresent()) {
            spawnPosition = Optional.of(new BlockPos((Vector3d)temporaryPosition.get()));
        }
        return spawnPosition.orElseGet(() -> ((ServerWorld)world).func_241135_u_());
    }
}

