/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.attributes;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;

public class AttributeHandler {
    protected final UUID uuid;
    protected final String name;
    protected final Attribute attribute;
    protected final AttributeModifier.Operation operation;
    private double value = 1.0;

    public static boolean hasAttribute(LivingEntity entity, Attribute attribute) {
        AttributeModifierManager attributeModifierManager = entity.func_233645_dx_();
        return attributeModifierManager.func_233790_b_(attribute);
    }

    public AttributeHandler(String uuid, String name, Attribute attribute, AttributeModifier.Operation operation) {
        this.uuid = UUID.fromString(uuid);
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
    }

    public AttributeHandler setValue(double value) {
        this.value = value;
        return this;
    }

    public double getValue() {
        return this.value;
    }

    public AttributeHandler apply(LivingEntity target) {
        ModifiableAttributeInstance attributeInstance = target.func_110148_a(this.attribute);
        if (attributeInstance != null) {
            attributeInstance.func_188479_b(this.uuid);
            AttributeModifier modifier = new AttributeModifier(this.uuid, this.name, this.value, this.operation);
            attributeInstance.func_233769_c_(modifier);
        }
        return this;
    }

    public AttributeHandler setValueAndApply(LivingEntity target, double value) {
        this.setValue(value);
        return this.apply(target);
    }
}

