/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.enchantments;

import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class EnchantmentHelperPlus {
    public static <InstanceType> int calculateEnchantmentSumIfIsInstanceOf(Enchantment enchantment, LivingEntity livingEntity, EquipmentSlotType[] slotTypes, Class<InstanceType> type) {
        int sum = 0;
        for (EquipmentSlotType slotType : slotTypes) {
            ItemStack itemStack = livingEntity.func_184582_a(slotType);
            if (!type.isInstance(itemStack.func_77973_b())) continue;
            sum += EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemStack);
        }
        return sum;
    }

    public static <InstanceType> int calculateEnchantmentSumIfIsInstanceOf(Enchantment enchantment, Iterable<ItemStack> itemStacks, Class<InstanceType> type) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        if (itemStacks != null) {
            for (ItemStack itemStack : itemStacks) {
                if (!type.isInstance(itemStack.func_77973_b())) continue;
                itemStackList.add(itemStack);
            }
        }
        return EnchantmentHelperPlus.calculateEnchantmentSum(enchantment, itemStackList);
    }

    public static int calculateEnchantmentSum(Enchantment enchantment, LivingEntity livingEntity, EquipmentSlotType[] slotTypes) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (EquipmentSlotType slotType : slotTypes) {
            itemStackList.add(livingEntity.func_184582_a(slotType));
        }
        return EnchantmentHelperPlus.calculateEnchantmentSum(enchantment, itemStackList);
    }

    public static int calculateEnchantmentSum(Enchantment enchantment, Iterable<ItemStack> itemStacks) {
        int sum = 0;
        if (itemStacks != null) {
            for (ItemStack itemStack : itemStacks) {
                sum += EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemStack);
            }
        }
        return sum;
    }
}

