/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.DeferredRegister;

public abstract class ExtendedEnchantment
extends Enchantment {
    private static final int DISABLE_ENCHANTMENT_VALUE = 9001;
    protected final String registerName;
    private int differenceBetweenMinimumAndMaximum = 10;
    private int maximumEnchantmentLevel = 1;
    private MinimumEnchantabilityCalculator minimumEnchantabilityCalculator = level -> level;

    protected ExtendedEnchantment(String registerName, Enchantment.Rarity rarity, EnchantmentType enchantmentType, EquipmentSlotType[] equipmentSlotTypes) {
        super(rarity, enchantmentType, equipmentSlotTypes);
        this.registerName = registerName;
    }

    protected ExtendedEnchantment(String registerName, Enchantment.Rarity rarity, EnchantmentType enchantmentType, EquipmentSlotType equipmentSlotType) {
        this(registerName, rarity, enchantmentType, new EquipmentSlotType[]{equipmentSlotType});
    }

    @Deprecated
    protected ExtendedEnchantment(Enchantment.Rarity rarity, EnchantmentType enchantmentType, EquipmentSlotType equipmentSlotType) {
        this(rarity, enchantmentType, new EquipmentSlotType[]{equipmentSlotType});
    }

    @Deprecated
    protected ExtendedEnchantment(Enchantment.Rarity rarity, EnchantmentType enchantmentType, EquipmentSlotType[] equipmentSlotTypes) {
        this("missing_name", rarity, enchantmentType, equipmentSlotTypes);
    }

    public int func_77325_b() {
        return this.maximumEnchantmentLevel;
    }

    public int func_77321_a(int level) {
        return this.isDisabled() ? 9001 : this.minimumEnchantabilityCalculator.getMinimumLevel(level);
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + this.differenceBetweenMinimumAndMaximum;
    }

    public boolean func_92089_a(ItemStack stack) {
        return !this.isDisabled() && super.func_92089_a(stack);
    }

    public boolean func_230309_h_() {
        return !this.isDisabled() && super.func_230309_h_();
    }

    public boolean func_230310_i_() {
        return !this.isDisabled() && super.func_230310_i_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return !this.isDisabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return !this.isDisabled() && super.isAllowedOnBooks();
    }

    public void register(DeferredRegister<Enchantment> enchantments) {
        enchantments.register(this.registerName, () -> this);
    }

    protected abstract boolean isDisabled();

    protected void setDifferenceBetweenMinimumAndMaximum(int differenceInLevels) {
        this.differenceBetweenMinimumAndMaximum = Math.max(1, differenceInLevels);
    }

    protected void setMinimumEnchantabilityCalculator(MinimumEnchantabilityCalculator minimumEnchantabilityCalculator) {
        this.minimumEnchantabilityCalculator = minimumEnchantabilityCalculator;
    }

    protected void setMaximumEnchantmentLevel(int enchantmentLevel) {
        this.maximumEnchantmentLevel = Math.max(1, enchantmentLevel);
    }

    @FunctionalInterface
    protected static interface MinimumEnchantabilityCalculator {
        public int getMinimumLevel(int var1);
    }
}

