/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.items;

import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class SpawnEggFactory {
    private static final SpawnEggBehavior SPAWN_EGG_BEHAVIOR = new SpawnEggBehavior();
    private static ItemGroup ITEM_GROUP = ItemGroup.field_78026_f;

    public static void addDispenseBehaviorTo(SpawnEggItem spawnEgg) {
        DispenserBlock.func_199774_a((IItemProvider)spawnEgg, (IDispenseItemBehavior)SPAWN_EGG_BEHAVIOR);
    }

    public static SpawnEggItem createSpawnEgg(EntityType<?> entityType, int primaryColor, int secondaryColor) {
        Item.Properties itemProperties = new Item.Properties().func_200916_a(ITEM_GROUP);
        SpawnEggItem spawnEggItem = new SpawnEggItem(entityType, primaryColor, secondaryColor, itemProperties);
        SpawnEggFactory.addDispenseBehaviorTo(spawnEggItem);
        return spawnEggItem;
    }

    public static RegistryObject<SpawnEggItem> createRegistrySpawnEgg(DeferredRegister<Item> deferredRegister, String registryName, EntityType<?> entityType, int primaryColor, int secondaryColor) {
        return deferredRegister.register(registryName, () -> SpawnEggFactory.createSpawnEgg(entityType, primaryColor, secondaryColor));
    }

    public static RegistryObject<SpawnEggItem> createRegistrySpawnEgg(DeferredRegister<Item> deferredRegister, String registryName, SpawnEggItem spawnEgg) {
        return deferredRegister.register(registryName, () -> spawnEgg);
    }

    public static void setDefaultItemGroup(ItemGroup itemGroup) {
        ITEM_GROUP = itemGroup;
    }

    private static final class SpawnEggBehavior
    extends DefaultDispenseItemBehavior {
        private SpawnEggBehavior() {
        }

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos blockPosition = source.func_180699_d();
            BlockState blockState = source.func_189992_e();
            Direction direction = (Direction)blockState.func_177229_b((Property)DispenserBlock.field_176441_a);
            EntityType entityType = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            entityType.func_220331_a(source.func_197524_h(), stack, null, blockPosition.func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            stack.func_190918_g(1);
            return stack;
        }
    }
}

