/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty;

import com.majruszs_difficulty.Instances;
import com.mlib.LevelHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GameState {
    public static final ChatFormatting NORMAL_MODE_COLOR = ChatFormatting.WHITE;
    public static final ChatFormatting EXPERT_MODE_COLOR = ChatFormatting.RED;
    public static final ChatFormatting MASTER_MODE_COLOR = ChatFormatting.DARK_PURPLE;
    private static State CURRENT = State.NORMAL;

    public static boolean changeMode(State state) {
        if (state == CURRENT) {
            return false;
        }
        CURRENT = state;
        return true;
    }

    public static boolean changeModeWithAdvancement(State state, MinecraftServer minecraftServer) {
        if (!GameState.changeMode(state)) {
            return false;
        }
        GameState.triggerAdvancement(minecraftServer);
        return true;
    }

    public static void triggerAdvancement(MinecraftServer minecraftServer) {
        minecraftServer.m_6846_().m_11314_().forEach(GameState::triggerAdvancement);
    }

    public static void triggerAdvancement(ServerPlayer player) {
        Instances.GAME_STATE_TRIGGER.trigger(player, CURRENT);
    }

    public static State getCurrentMode() {
        return CURRENT;
    }

    public static boolean atLeast(State state) {
        return GameState.getValueDependingOnGameState(state, true, CURRENT == State.EXPERT || CURRENT == State.MASTER, CURRENT == State.MASTER);
    }

    public static int convertStateToInteger(State state) {
        return GameState.getValueDependingOnGameState(state, 0, 1, 2);
    }

    public static State convertIntegerToState(int mode) {
        return switch (mode) {
            default -> State.NORMAL;
            case 1 -> State.EXPERT;
            case 2 -> State.MASTER;
        };
    }

    public static <ConfigType> ConfigType getValueDependingOnGameState(State state, ConfigType normal, ConfigType expert, ConfigType master) {
        return switch (state) {
            default -> normal;
            case State.EXPERT -> expert;
            case State.MASTER -> master;
        };
    }

    public static <ConfigType> ConfigType getValueDependingOnCurrentGameState(ConfigType normal, ConfigType expert, ConfigType master) {
        return GameState.getValueDependingOnGameState(CURRENT, normal, expert, master);
    }

    public static MutableComponent getGameStateText(State state) {
        String modeName = GameState.getValueDependingOnGameState(state, "normal", "expert", "master");
        ChatFormatting textColor = GameState.getValueDependingOnGameState(state, NORMAL_MODE_COLOR, EXPERT_MODE_COLOR, MASTER_MODE_COLOR);
        return GameState.generateModeText(modeName, textColor);
    }

    public static double getRegionalDifficulty(LivingEntity target) {
        double clampedRegionalDifficulty = target != null ? LevelHelper.getClampedRegionalDifficulty((Entity)target) : 0.25;
        double stateModifier = GameState.getStateModifier();
        return Mth.m_14008_((double)(clampedRegionalDifficulty + stateModifier), (double)0.0, (double)1.0);
    }

    public static double getRegionalDifficulty(Level level, Vec3 position) {
        double clampedRegionalDifficulty = LevelHelper.getClampedRegionalDifficulty((Level)level, (Vec3)position);
        double stateModifier = GameState.getStateModifier();
        return Mth.m_14008_((double)(clampedRegionalDifficulty + stateModifier), (double)0.0, (double)1.0);
    }

    public static double getStateModifier() {
        return GameState.getValueDependingOnCurrentGameState(0.0, 0.15, 0.3);
    }

    private static MutableComponent generateModeText(String modeName, ChatFormatting color) {
        TranslatableComponent text = new TranslatableComponent("majruszs_difficulty.states." + modeName);
        text.m_130944_(new ChatFormatting[]{color, ChatFormatting.BOLD});
        return text;
    }

    public static enum State {
        NORMAL,
        EXPERT,
        MASTER;

    }
}

