/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.blocks;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.mlib.MajruszLibrary;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EndShardOre
extends Block {
    private static final String WARNING_TRANSLATION_KEY = "block.majruszs_difficulty.end_shard_ore.warning";
    protected final ConfigGroup configGroup;
    protected final AvailabilityConfig availability;
    protected final DoubleConfig triggerDistance;

    public EndShardOre() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76416_).m_60999_().m_60913_(30.0f, 1200.0f).m_60918_(SoundType.f_56726_));
        String availabilityComment = "Should this ore be available in survival mode? (ore generation, loot tables etc.) (requires game restart!)";
        this.availability = new AvailabilityConfig("is_enabled", availabilityComment, true, true);
        String triggerComment = "Maximum distance within which all nearby Endermans are being triggered. (when block was mined)";
        this.triggerDistance = new DoubleConfig("trigger_distance", triggerComment, false, 450.0, 0.0, 1000000.0);
        this.configGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("EndShardOre", "Configuration for new late game ore."));
        this.configGroup.addConfigs(new IConfig[]{this.availability, this.triggerDistance});
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos position, int fortuneLevel, int silkTouchLevel) {
        return silkTouchLevel == 0 ? Mth.m_14072_((Random)MajruszLibrary.RANDOM, (int)6, (int)11) : 0;
    }

    @SubscribeEvent
    public static void onBlockDestroying(PlayerEvent.BreakSpeed event) {
        BlockState blockState = event.getState();
        if (!(blockState.m_60734_() instanceof EndShardOre)) {
            return;
        }
        Player player = event.getPlayer();
        player.m_5661_((Component)new TranslatableComponent(WARNING_TRANSLATION_KEY).m_130940_(ChatFormatting.BOLD), true);
    }

    @SubscribeEvent
    public static void onBlockDestroy(BlockEvent.BreakEvent event) {
        BlockState blockState = event.getState();
        if (blockState.m_60734_() instanceof EndShardOre) {
            EndShardOre.targetEndermansOnEntity((LivingEntity)event.getPlayer(), Instances.END_SHARD_ORE.triggerDistance.get());
        }
    }

    public static void targetEndermansOnEntity(LivingEntity target, double maximumDistance) {
        if (!(target.f_19853_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)target.f_19853_;
        AABB aabb = target.m_142469_().m_82377_(100.0, 16.0, 100.0);
        for (EnderMan enderman2 : world.m_6443_(EnderMan.class, aabb, enderman -> enderman.m_20280_((Entity)target) < maximumDistance)) {
            LivingEntity currentEndermanTarget = enderman2.m_142581_();
            if (currentEndermanTarget != null && currentEndermanTarget.m_6084_()) continue;
            enderman2.m_6703_(target);
        }
    }

    public boolean isEnabled() {
        return this.availability.isEnabled();
    }

    public static class EndShardOreItem
    extends BlockItem {
        public EndShardOreItem() {
            super((Block)Instances.END_SHARD_ORE, new Item.Properties().m_41487_(64).m_41491_(Instances.ITEM_GROUP));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
            MajruszsHelper.addExtraTextIfItemIsDisabled(tooltip, Instances.END_SHARD_ORE.isEnabled());
        }
    }
}

