/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.config.GameStateDoubleConfig;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfig;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExperienceBonus {
    protected final ConfigGroup experienceGroup;
    protected final GameStateDoubleConfig bonusMultiplier;

    public ExperienceBonus() {
        String expComment = "Extra experience multiplier.";
        String groupComment = "Experience bonuses.";
        this.bonusMultiplier = new GameStateDoubleConfig("BonusMultiplier", expComment, 0.0, 0.25, 0.5, 0.0, 10.0);
        this.experienceGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("Experience", groupComment));
        this.experienceGroup.addConfig((IConfig)this.bonusMultiplier);
    }

    @SubscribeEvent
    public static void onXPPickUp(PlayerXpEvent.PickupXp event) {
        int bonusExperience = Instances.EXPERIENCE_BONUS.getExtraExperience(event.getOrb());
        if (bonusExperience <= 0) {
            return;
        }
        Player player = event.getPlayer();
        player.m_6756_(bonusExperience);
    }

    private int getExtraExperience(ExperienceOrb experienceOrb) {
        return Random.randomizeExperience((double)(this.getExperienceMultiplier() * (double)experienceOrb.m_20801_()));
    }

    private double getExperienceMultiplier() {
        return this.bonusMultiplier.getCurrentGameStateValue();
    }
}

