/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.mlib.MajruszLibrary;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;

public class ApplyingNegativeEffectOnCreeperOnSpawn
extends OnEnemyToBeSpawnedBase {
    protected static final MobEffect[] EFFECTS = new MobEffect[]{MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19599_, MobEffects.f_19618_};
    private static final String CONFIG_NAME = "CreeperEffects";
    private static final String CONFIG_COMMENT = "Creeper spawns with negative effects applied.";
    protected final DurationConfig duration;

    public ApplyingNegativeEffectOnCreeperOnSpawn() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.375, GameState.State.NORMAL, true);
        String comment = "Duration of effects applied to creeper.";
        this.duration = new DurationConfig("duration", comment, false, 6.0, 1.0, 60.0);
        this.featureGroup.addConfig((IConfig)this.duration);
    }

    @Override
    public void onExecute(LivingEntity entity, ServerLevel world) {
        Creeper creeper = (Creeper)entity;
        MobEffect randomEffect = EFFECTS[MajruszLibrary.RANDOM.nextInt(EFFECTS.length)];
        creeper.m_7292_(new MobEffectInstance(randomEffect, this.duration.getDuration(), 0));
    }

    @Override
    public boolean shouldBeExecuted(LivingEntity entity) {
        return entity instanceof Creeper && super.shouldBeExecuted(entity);
    }
}

