/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.mlib.TimeConverter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnEnemyToBeSpawnedEvent {
    public static final List<OnEnemyToBeSpawnedBase> REGISTRY_LIST = new ArrayList<OnEnemyToBeSpawnedBase>();
    private static final String MARK_TAG = "MajruszDifficultyEntityMarked";
    private static final int cooldown = TimeConverter.secondsToTicks((double)10.0);
    private static int counter = 0;

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        OnEnemyToBeSpawnedEvent.markEntity((Entity)entity);
        for (OnEnemyToBeSpawnedBase register : REGISTRY_LIST) {
            if (!register.shouldBeExecuted(entity)) continue;
            register.onExecute(entity, (ServerLevel)entity.f_19853_);
            if (!register.shouldSpawnBeCancelled()) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (!(event.world instanceof ServerLevel) || event.phase == TickEvent.Phase.START) {
            return;
        }
        ServerLevel world = (ServerLevel)event.world;
        if (++counter % cooldown != 0) {
            return;
        }
        LevelEntityGetter entities = world.m_142646_();
        for (Entity entity : entities.m_142273_()) {
            if (!(entity instanceof LivingEntity) || OnEnemyToBeSpawnedEvent.isMarked(entity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            OnEnemyToBeSpawnedEvent.markEntity((Entity)livingEntity);
            for (OnEnemyToBeSpawnedBase register : REGISTRY_LIST) {
                if (!register.shouldBeExecuted(livingEntity)) continue;
                register.onExecute(livingEntity, world);
            }
        }
    }

    private static void markEntity(Entity entity) {
        CompoundTag data = entity.getPersistentData();
        data.m_128379_(MARK_TAG, true);
    }

    private static boolean isMarked(Entity entity) {
        CompoundTag data = entity.getPersistentData();
        return data.m_128441_(MARK_TAG) && data.m_128471_(MARK_TAG);
    }
}

