/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.on_death;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.features.on_death.OnDeathBase;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SpawnPlayerZombieOnDeath
extends OnDeathBase {
    private static final String CONFIG_NAME = "PlayerZombie";
    private static final String CONFIG_COMMENT = "Spawns special Zombie whenever player dies from Bleeding or Zombie.";
    protected final DoubleConfig playerHeadChance;
    protected final DoubleConfig playerHeadDropChance;

    public SpawnPlayerZombieOnDeath() {
        super(CONFIG_NAME, CONFIG_COMMENT, 1.0, GameState.State.EXPERT, false);
        String headComment = "Chance for spawned Zombie to have a player's head.";
        this.playerHeadChance = new DoubleConfig("head_chance", headComment, false, 1.0, 0.0, 1.0);
        String chanceComment = "Chance for special Zombie to drop a player's head on death. (if it has one)";
        this.playerHeadDropChance = new DoubleConfig("head_drop_chance", chanceComment, false, 0.01, 0.0, 1.0);
        this.featureGroup.addConfigs(new IConfig[]{this.playerHeadChance, this.playerHeadDropChance});
    }

    @Override
    public void onExecute(@Nullable LivingEntity attacker, LivingEntity target, LivingDeathEvent event) {
        ServerLevel world = (ServerLevel)target.f_19853_;
        Player player = (Player)target;
        EntityType<? extends Zombie> zombieType = this.getZombieType(attacker);
        Entity entity = zombieType.m_20592_(world, null, null, player.m_142538_(), MobSpawnType.EVENT, true, true);
        if (entity == null) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (Random.tryChance((double)this.playerHeadChance.get())) {
            ItemStack playerSkull = this.getHead(player);
            zombie.m_8061_(EquipmentSlot.HEAD, playerSkull);
            zombie.m_21409_(EquipmentSlot.HEAD, (float)this.playerHeadDropChance.get().doubleValue());
        }
        zombie.m_6593_(player.m_7755_());
        zombie.m_21553_(false);
        zombie.m_21530_();
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        boolean hasPlayerDied = target instanceof Player;
        boolean hasDiedFromBleeding = damageSource.f_19326_.equals(Instances.BLEEDING_SOURCE.f_19326_);
        boolean hasDiedFromZombie = attacker instanceof Zombie;
        return super.shouldBeExecuted(attacker, target, damageSource) && hasPlayerDied && (hasDiedFromZombie || hasDiedFromBleeding);
    }

    private ItemStack getHead(Player player) {
        ItemStack playerSkull = new ItemStack((ItemLike)Items.f_42680_, 1);
        CompoundTag nbt = playerSkull.m_41784_();
        nbt.m_128359_("SkullOwner", player.m_6302_());
        playerSkull.m_41751_(nbt);
        return playerSkull;
    }

    private EntityType<? extends Zombie> getZombieType(@Nullable LivingEntity attacker) {
        if (attacker instanceof ZombifiedPiglin) {
            return EntityType.f_20531_;
        }
        if (attacker instanceof Husk) {
            return EntityType.f_20458_;
        }
        return EntityType.f_20501_;
    }
}

