/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.treasure_bag;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.config.GameStateIntegerConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfig;
import com.mlib.items.ItemHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FishingRewarder {
    protected static final String FISHING_TAG = "FishermanTreasureBagCounter";
    protected final ConfigGroup fishingGroup;
    protected final GameStateIntegerConfig treasureBagRequirement;

    public FishingRewarder() {
        String requirementComment = "Required amount of items fished to get Treasure Bag.";
        String groupComment = "Everything related to fishing.";
        this.treasureBagRequirement = new GameStateIntegerConfig("RequiredItems", requirementComment, 20, 15, 10, 3, 100);
        this.fishingGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("Fishing", groupComment));
        this.fishingGroup.addConfig((IConfig)this.treasureBagRequirement);
    }

    @SubscribeEvent
    public static void onFishing(ItemFishedEvent event) {
        Player player = event.getPlayer();
        if (!(player.f_19853_ instanceof ServerLevel)) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        int fishedItemsCounter = data.m_128451_(FISHING_TAG) + 1;
        data.m_128405_(FISHING_TAG, fishedItemsCounter);
        if (fishedItemsCounter >= Instances.FISHING_REWARDER.getRequiredItems()) {
            data.m_128405_(FISHING_TAG, fishedItemsCounter - Instances.FISHING_REWARDER.getRequiredItems());
            if (Instances.FISHING_TREASURE_BAG.isAvailable()) {
                FishingRewarder.giveTreasureBagTo(player);
            }
        }
    }

    protected static void giveTreasureBagTo(Player player) {
        ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((ItemLike)Instances.FISHING_TREASURE_BAG), (Player)player, (ServerLevel)((ServerLevel)player.f_19853_));
    }

    protected int getRequiredItems() {
        return this.treasureBagRequirement.getCurrentGameStateValue();
    }
}

