/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.treasure_bag;

import com.majruszs_difficulty.ObfuscationGetter;
import com.majruszs_difficulty.PacketHandler;
import com.majruszs_difficulty.features.treasure_bag.LootData;
import com.majruszs_difficulty.features.treasure_bag.LootProgressClient;
import com.majruszs_difficulty.items.TreasureBagItem;
import com.mlib.CommonHelper;
import com.mlib.network.message.EntityMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class LootProgress {
    public static ObfuscationGetter<LootTable, List<LootPool>> POOLS_GETTER = new ObfuscationGetter(LootTable.class, "pools", "f_79109_");
    public static ObfuscationGetter<LootPool, LootPoolEntryContainer[]> ENTRIES_GETTER = new ObfuscationGetter(LootPool.class, "entries", "f_79023_");

    @SubscribeEvent
    public static void onSpawn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        for (TreasureBagItem treasureBagItem : TreasureBagItem.TREASURE_BAGS) {
            LootProgress.createDefaultProgressIfPossible(player, treasureBagItem);
        }
        LootProgress.notifyPlayerAboutChanges(player);
    }

    public static void cleanProgress(Player player) {
        for (TreasureBagItem treasureBagItem : TreasureBagItem.TREASURE_BAGS) {
            String bagID = CommonHelper.getRegistryNameString((IForgeRegistryEntry)treasureBagItem);
            if (bagID == null) continue;
            CompoundTag compoundTag = player.getPersistentData();
            if (compoundTag.m_128441_(bagID)) {
                compoundTag.m_128473_(bagID);
            }
            LootProgress.createDefaultProgressIfPossible(player, treasureBagItem);
        }
        LootProgress.notifyPlayerAboutChanges(player);
    }

    public static void updateProgress(TreasureBagItem treasureBagItem, Player player, List<ItemStack> generatedLoot) {
        String bagID = CommonHelper.getRegistryNameString((IForgeRegistryEntry)treasureBagItem);
        if (bagID == null) {
            return;
        }
        for (ItemStack itemStack : generatedLoot) {
            CompoundTag treasureBagTag;
            CompoundTag compoundTag;
            String itemID = CommonHelper.getRegistryNameString((IForgeRegistryEntry)itemStack.m_41720_());
            if (itemID == null || !(compoundTag = player.getPersistentData()).m_128441_(bagID) || !(treasureBagTag = compoundTag.m_128469_(bagID)).m_128441_(itemID)) continue;
            LootData lootData = LootData.read(treasureBagTag, itemID);
            lootData.isUnlocked = true;
            lootData.write(treasureBagTag);
            compoundTag.m_128365_(bagID, (Tag)treasureBagTag);
        }
        LootProgress.notifyPlayerAboutChanges(player, treasureBagItem);
    }

    protected static void createDefaultProgressIfPossible(Player player, TreasureBagItem treasureBagItem) {
        String bagID = CommonHelper.getRegistryNameString((IForgeRegistryEntry)treasureBagItem);
        if (bagID == null) {
            return;
        }
        List<LootPool> pools = POOLS_GETTER.get(treasureBagItem.getLootTable());
        if (pools == null) {
            return;
        }
        LootContext context = TreasureBagItem.generateLootContext(player);
        for (LootPool lootPool : pools) {
            LootPoolEntryContainer[] entries = ENTRIES_GETTER.get(lootPool);
            if (entries == null) {
                return;
            }
            for (LootPoolEntryContainer entryContainer : entries) {
                LootItem lootItem = (LootItem)CommonHelper.castIfPossible(LootItem.class, (Object)entryContainer);
                if (lootItem == null) continue;
                lootItem.m_6948_(itemStack -> {
                    CompoundTag compoundTag;
                    CompoundTag treasureBagTag;
                    String itemID = CommonHelper.getRegistryNameString((IForgeRegistryEntry)itemStack.m_41720_());
                    if (itemID == null) {
                        return;
                    }
                    if (itemID.equals("minecraft:book")) {
                        itemID = "minecraft:enchanted_book";
                    }
                    CompoundTag compoundTag2 = treasureBagTag = (compoundTag = player.getPersistentData()).m_128441_(bagID) ? compoundTag.m_128469_(bagID) : new CompoundTag();
                    if (!treasureBagTag.m_128441_(itemID)) {
                        LootData lootData = new LootData(itemID, false, lootItem.f_79676_);
                        lootData.write(treasureBagTag);
                    }
                    compoundTag.m_128365_(bagID, (Tag)treasureBagTag);
                }, context);
            }
        }
    }

    protected static void notifyPlayerAboutChanges(Player player, TreasureBagItem treasureBagItem) {
        ServerPlayer serverPlayer = (ServerPlayer)CommonHelper.castIfPossible(ServerPlayer.class, (Object)player);
        if (serverPlayer == null) {
            return;
        }
        String bagID = CommonHelper.getRegistryNameString((IForgeRegistryEntry)treasureBagItem);
        if (bagID == null) {
            return;
        }
        ArrayList<LootData> lootDataList = new ArrayList<LootData>();
        CompoundTag compoundTag = player.getPersistentData();
        if (!compoundTag.m_128441_(bagID)) {
            return;
        }
        CompoundTag treasureBagTag = compoundTag.m_128469_(bagID);
        for (String itemID : treasureBagTag.m_128431_()) {
            lootDataList.add(LootData.read(treasureBagTag, itemID));
        }
        lootDataList.sort(Comparator.comparingInt(a -> -a.quality));
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ProgressMessage((Entity)serverPlayer, bagID, lootDataList));
    }

    protected static void notifyPlayerAboutChanges(Player player) {
        for (TreasureBagItem treasureBagItem : TreasureBagItem.TREASURE_BAGS) {
            LootProgress.notifyPlayerAboutChanges(player, treasureBagItem);
        }
    }

    public static class ProgressMessage
    extends EntityMessage {
        private final String treasureBagID;
        private final List<LootData> lootDataList;

        public ProgressMessage(Entity entity, String treasureBagID, List<LootData> lootDataList) {
            super(entity);
            this.treasureBagID = treasureBagID;
            this.lootDataList = lootDataList;
        }

        public ProgressMessage(FriendlyByteBuf buffer) {
            super(buffer);
            this.treasureBagID = buffer.m_130277_();
            this.lootDataList = buffer.m_178366_(byteBuffer -> new LootData(byteBuffer.m_130277_(), byteBuffer.readBoolean(), byteBuffer.readInt()));
        }

        public void encode(FriendlyByteBuf buffer) {
            super.encode(buffer);
            buffer.m_130070_(this.treasureBagID);
            buffer.m_178352_(this.lootDataList, (byteBuffer, lootData) -> {
                byteBuffer.m_130070_(lootData.itemID);
                byteBuffer.writeBoolean(lootData.isUnlocked);
                byteBuffer.writeInt(lootData.quality);
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        public void receiveMessage(NetworkEvent.Context context) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                LootProgressClient.generateComponents(this.treasureBagID, this.lootDataList);
            }
        }
    }
}

