/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.treasure_bag;

import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.features.treasure_bag.TreasureBagManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class UpdatePlayerList {
    @SubscribeEvent
    public static void onHit(LivingHurtEvent event) {
        Player player = MajruszsHelper.getPlayerFromDamageSource(event.getSource());
        LivingEntity target = event.getEntityLiving();
        if (player == null || !TreasureBagManager.hasTreasureBag(target.m_6095_())) {
            return;
        }
        ListTag listNBT = UpdatePlayerList.getOrCreateList(target);
        CompoundTag playerNBT = UpdatePlayerList.getPlayerCompound(player);
        if (!UpdatePlayerList.isPlayerInList(player, listNBT)) {
            listNBT.add((Object)playerNBT);
        }
        CompoundTag data = target.getPersistentData();
        data.m_128365_("TreasureBagPlayersToReward", (Tag)listNBT);
    }

    protected static ListTag getOrCreateList(LivingEntity entity) {
        CompoundTag data = entity.getPersistentData();
        return data.m_128441_("TreasureBagPlayersToReward") ? data.m_128437_("TreasureBagPlayersToReward", 10) : new ListTag();
    }

    protected static String getPlayerUUID(Player player) {
        return String.valueOf(player.m_142081_());
    }

    protected static CompoundTag getPlayerCompound(Player player) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("TreasureBagPlayerUUID", UpdatePlayerList.getPlayerUUID(player));
        return nbt;
    }

    protected static boolean isPlayerInList(Player player, ListTag listNBT) {
        String uuid = UpdatePlayerList.getPlayerUUID(player);
        for (int i = 0; i < listNBT.size(); ++i) {
            if (!listNBT.m_128728_(i).m_128461_("TreasureBagPlayerUUID").equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

