/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.features.undead_army.UndeadArmyConfig;
import com.majruszs_difficulty.features.undead_army.UndeadArmyManager;
import com.mlib.damage.DamageHelper;
import com.mlib.nbt.NBTHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CountKilledUndead {
    @SubscribeEvent
    public static void onUndeadKill(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Player player = (Player)DamageHelper.castEntityIfPossible(Player.class, (DamageSource)event.getSource());
        UndeadArmyManager undeadArmyManager = RegistryHandler.UNDEAD_ARMY_MANAGER;
        if (player == null || undeadArmyManager == null || !CountKilledUndead.isValidEntity(entity) || undeadArmyManager.doesEntityBelongToUndeadArmy(entity)) {
            return;
        }
        NBTHelper.IntegerData killedUndeadData = new NBTHelper.IntegerData((LivingEntity)player, "UndeadKilled");
        killedUndeadData.set(kills -> kills + 1);
        CountKilledUndead.spawnArmyIfPossible(player);
    }

    private static boolean isValidEntity(LivingEntity entity) {
        return entity.f_19853_ instanceof ServerLevel && entity.m_6336_() == MobType.f_21641_;
    }

    private static void spawnArmyIfPossible(Player player) {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        UndeadArmyManager undeadArmyManager = RegistryHandler.UNDEAD_ARMY_MANAGER;
        NBTHelper.IntegerData killedUndeadData = new NBTHelper.IntegerData((LivingEntity)player, "UndeadKilled");
        if (killedUndeadData.get() >= config.getRequiredKills() && player.f_19853_ instanceof ServerLevel && undeadArmyManager != null && undeadArmyManager.tryToSpawn(player)) {
            killedUndeadData.set(Integer.valueOf(0));
        }
    }
}

