/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.google.common.collect.Sets;
import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.entities.TankEntity;
import com.majruszs_difficulty.features.undead_army.Direction;
import com.majruszs_difficulty.features.undead_army.Status;
import com.majruszs_difficulty.features.undead_army.UndeadArmyConfig;
import com.majruszs_difficulty.features.undead_army.UndeadArmyText;
import com.majruszs_difficulty.features.undead_army.WaveMembersConfig;
import com.majruszs_difficulty.goals.ForgiveUndeadArmyTargetGoal;
import com.majruszs_difficulty.goals.UndeadAttackPositionGoal;
import com.mlib.CommonHelper;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.TimeConverter;
import com.mlib.effects.EffectHelper;
import com.mlib.items.ItemHelper;
import com.mlib.nbt.NBTHelper;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class UndeadArmy {
    public static final int ARMOR_COLOR = 9595003;
    private static final int SAFE_SPAWN_RADIUS = 90;
    private static final int SPAWN_RADIUS = 70;
    private final ServerBossEvent bossInfo = new ServerBossEvent(UndeadArmyText.TITLE, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10);
    private final BlockPos positionToAttack;
    private final Direction direction;
    private Status status;
    private boolean isActive;
    private boolean spawnerWasCreated;
    private int ticksActive;
    private int ticksInactive;
    private int ticksInactiveMaximum;
    private int ticksWaveActive;
    private int ticksBetweenWaves;
    private int ticksBetweenWavesMaximum;
    private int currentWave;
    private int undeadToKill;
    private int undeadKilled;
    private ServerLevel level;

    public UndeadArmy(ServerLevel level, BlockPos positionToAttack, Direction direction) {
        this.positionToAttack = positionToAttack;
        this.direction = direction;
        this.status = Status.BETWEEN_WAVES;
        this.isActive = true;
        this.spawnerWasCreated = false;
        this.ticksActive = 0;
        this.ticksInactive = 0;
        this.ticksWaveActive = 0;
        this.ticksBetweenWaves = 0;
        this.currentWave = 0;
        this.undeadToKill = 1;
        this.undeadKilled = 0;
        this.level = level;
        this.setConfigurationValues();
        this.bossInfo.m_142711_(0.0f);
    }

    public UndeadArmy(ServerLevel level, CompoundTag nbt) {
        this.positionToAttack = NBTHelper.loadBlockPos((CompoundTag)nbt, (String)"UndeadArmyPosition");
        this.direction = Direction.getByName(nbt.m_128461_("Direction"));
        this.status = Status.getByName(nbt.m_128461_("Status"));
        this.isActive = nbt.m_128471_("IsActive");
        this.spawnerWasCreated = nbt.m_128471_("SpawnerWasCreated");
        this.ticksActive = nbt.m_128451_("TicksActive");
        this.ticksInactive = nbt.m_128451_("TicksInactive");
        this.ticksWaveActive = nbt.m_128451_("TicksWaveActive");
        this.ticksBetweenWaves = nbt.m_128451_("BetweenRaidTick");
        this.currentWave = nbt.m_128451_("CurrentWave");
        this.undeadToKill = nbt.m_128451_("UndeadToKill");
        this.undeadKilled = nbt.m_128451_("UndeadKilled");
        this.level = level;
        this.setConfigurationValues();
        this.updateBarText();
    }

    public static boolean doesEntityBelongToUndeadArmy(LivingEntity entity) {
        return entity.getPersistentData().m_128441_("UndeadArmyPositionX") && !(entity instanceof SkeletonHorse);
    }

    private void setConfigurationValues() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        this.ticksBetweenWaves = this.ticksBetweenWavesMaximum = config.getAmountOfTicksBetweenWaves();
        this.ticksInactiveMaximum = config.getAmountOfInactivityTicks();
    }

    public CompoundTag write(CompoundTag nbt) {
        NBTHelper.saveBlockPos((CompoundTag)nbt, (String)"UndeadArmyPosition", (BlockPos)this.positionToAttack);
        nbt.m_128359_("Direction", String.valueOf((Object)this.direction));
        nbt.m_128359_("Status", String.valueOf((Object)this.status));
        nbt.m_128379_("IsActive", this.isActive);
        nbt.m_128379_("SpawnerWasCreated", this.spawnerWasCreated);
        nbt.m_128405_("TicksActive", this.ticksActive);
        nbt.m_128405_("TicksInactive", this.ticksInactive);
        nbt.m_128405_("TicksWaveActive", this.ticksWaveActive);
        nbt.m_128405_("BetweenRaidTick", this.ticksBetweenWaves);
        nbt.m_128405_("CurrentWave", this.currentWave);
        nbt.m_128405_("UndeadToKill", this.undeadToKill);
        nbt.m_128405_("UndeadKilled", this.undeadKilled);
        return nbt;
    }

    public BlockPos getAttackPosition() {
        return this.positionToAttack;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void updateWorld(ServerLevel world) {
        this.level = world;
    }

    public void updateBarText() {
        switch (this.status) {
            case ONGOING: {
                this.bossInfo.m_6456_(this.currentWave == 0 ? UndeadArmyText.TITLE : UndeadArmyText.getWaveMessage(this.currentWave));
                break;
            }
            case BETWEEN_WAVES: {
                this.bossInfo.m_6456_(UndeadArmyText.BETWEEN_WAVES);
                break;
            }
            case VICTORY: {
                this.bossInfo.m_6456_(UndeadArmyText.VICTORY);
                break;
            }
            case FAILED: {
                this.bossInfo.m_6456_(UndeadArmyText.FAILED);
                break;
            }
        }
    }

    public void tick() {
        if (!this.isActive()) {
            return;
        }
        if (this.ticksActive == 0) {
            UndeadArmyText.notifyAboutStart(this.getNearbyPlayers(), this.direction);
        }
        if (this.ticksActive % 20 == 0) {
            this.updateUndeadArmyBarVisibility();
        }
        this.tickCurrentStatus();
        ++this.ticksActive;
    }

    public void tickCurrentStatus() {
        switch (this.status) {
            case BETWEEN_WAVES: {
                this.tickBetweenWaves();
                break;
            }
            case ONGOING: {
                this.tickOngoing();
                break;
            }
            case VICTORY: 
            case FAILED: {
                this.tickFinished();
                break;
            }
            case STOPPED: {
                this.tickStopped();
            }
        }
    }

    private void tickBetweenWaves() {
        --this.ticksBetweenWaves;
        this.bossInfo.m_142711_(Mth.m_14036_((float)(1.0f - (float)this.ticksBetweenWaves / (float)this.ticksBetweenWavesMaximum), (float)0.0f, (float)1.0f));
        if (this.ticksBetweenWaves == 0) {
            this.nextWave();
        }
    }

    private void tickOngoing() {
        this.bossInfo.m_142711_(Mth.m_14036_((float)(1.0f - (float)this.undeadKilled / (float)this.undeadToKill), (float)0.0f, (float)1.0f));
        if (this.countNearbyPlayers() == 0) {
            this.status = Status.STOPPED;
        }
        if (!this.spawnerWasCreated && this.countNearbyUndeadArmy(10.0) >= this.undeadToKill / 2 && this.countNearbyPlayers(10.0) == 0) {
            this.createSpawner();
        }
        if (this.shouldWaveEndPrematurely()) {
            this.killAllUndeadArmyEntities();
        }
        if (this.undeadKilled == this.undeadToKill) {
            this.endWave();
        }
        if (this.shouldEntitiesBeHighlighted()) {
            this.highlightUndeadArmy();
        }
        ++this.ticksWaveActive;
    }

    private void tickFinished() {
        this.ticksBetweenWaves = Math.max(this.ticksBetweenWaves - 1, 0);
        if (this.ticksBetweenWaves == 0) {
            this.finish();
        }
    }

    private void tickStopped() {
        ++this.ticksInactive;
        if (this.countNearbyPlayers() > 0) {
            this.status = Status.ONGOING;
        }
        if (this.ticksInactive >= this.ticksInactiveMaximum) {
            this.status = Status.FAILED;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum * 2;
            this.bossInfo.m_142711_(1.0f);
            this.spawnerWasCreated = false;
            this.createSpawner();
        }
    }

    public void increaseUndeadCounter() {
        this.undeadKilled = Math.min(this.undeadKilled + 1, this.undeadToKill);
    }

    public void highlightUndeadArmy() {
        for (Mob monster : this.getNearbyUndeadArmy(90.0)) {
            EffectHelper.applyEffectIfPossible((LivingEntity)monster, (MobEffect)MobEffects.f_19619_, (int)TimeConverter.secondsToTicks((double)15.0), (int)5);
        }
    }

    public int countUndeadEntitiesLeft() {
        return this.countNearbyUndeadArmy(90.0);
    }

    public void updateNearbyUndeadAIGoals() {
        List<Mob> monsters = this.getNearbyUndeadArmy(90.0);
        for (Mob monster : monsters) {
            this.updateUndeadAIGoal(monster);
        }
    }

    public void finish() {
        this.isActive = false;
        this.bossInfo.m_7706_();
    }

    public void killAllUndeadArmyEntities() {
        for (Mob monster : this.getNearbyUndeadArmy(90.0)) {
            monster.m_6469_(DamageSource.f_19319_, 9001.0f);
        }
        this.undeadKilled = this.undeadToKill;
    }

    private void nextWave() {
        ++this.currentWave;
        this.status = Status.ONGOING;
        this.ticksWaveActive = 0;
        this.spawnWaveEnemies();
        this.updateBarText();
    }

    private void endWave() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        if (this.currentWave >= config.getWaves()) {
            this.status = Status.VICTORY;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum * 2;
            this.rewardPlayers();
            this.bossInfo.m_142711_(1.0f);
        } else {
            this.status = Status.BETWEEN_WAVES;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum;
        }
        this.updateBarText();
    }

    private void createSpawner() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        int spawnerRange = 5;
        for (int i = 0; i < 50 && !this.spawnerWasCreated; ++i) {
            int z;
            int y;
            int x = this.positionToAttack.m_123341_() + MajruszLibrary.RANDOM.nextInt(spawnerRange * 2 + 1) - spawnerRange;
            BlockPos position = new BlockPos(x, y = this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = this.positionToAttack.m_123343_() + MajruszLibrary.RANDOM.nextInt(spawnerRange * 2 + 1) - spawnerRange), z);
            if (!this.level.m_46859_(position)) continue;
            this.level.m_46597_(position, Blocks.f_50085_.m_49966_());
            this.spawnerWasCreated = true;
            SpawnerBlockEntity spawnerEntity = (SpawnerBlockEntity)CommonHelper.castIfPossible(SpawnerBlockEntity.class, (Object)this.level.m_7702_(position));
            if (spawnerEntity == null) continue;
            spawnerEntity.m_59801_().m_45462_(config.getEntityTypeForMonsterSpawner());
            this.level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)x, (double)y, (double)z, 40, 0.5, 0.5, 0.5, 0.01);
        }
        this.spawnerWasCreated = true;
    }

    private void spawnWaveEnemies() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        double playersFactor = config.getSizeMultiplier(this.countNearbyPlayers());
        this.undeadToKill = 0;
        this.undeadKilled = 0;
        for (WaveMembersConfig.WaveMember waveMember : config.getWaveMembers(this.currentWave)) {
            waveMember.amount = (int)((double)waveMember.amount * playersFactor);
            for (int i = 0; i < waveMember.amount; ++i) {
                BlockPos randomPosition = this.direction.getRandomSpawnPosition(this.level, this.positionToAttack, 70);
                Entity entity = waveMember.entityType.m_20655_(this.level, null, null, null, randomPosition, MobSpawnType.EVENT, true, true);
                if (!(entity instanceof Mob)) continue;
                Mob monster = (Mob)entity;
                monster.m_21530_();
                this.updateUndeadAIGoal(monster);
                this.equipWithDyedLeatherArmor(monster);
                this.tryToEnchantEquipment(monster);
                this.markAsUndeadArmyUnit((LivingEntity)monster);
                if (monster instanceof Skeleton && Random.tryChance((double)config.getSkeletonHorseChance())) {
                    this.spawnOnSkeletonHorse(monster);
                }
                monster.m_21553_(false);
                if (ForgeEventFactory.doSpecialSpawn((Mob)monster, (Level)this.level, (float)randomPosition.m_123341_(), (float)randomPosition.m_123342_(), (float)randomPosition.m_123343_(), null, (MobSpawnType)MobSpawnType.EVENT)) continue;
                this.level.m_7967_((Entity)monster);
                ++this.undeadToKill;
            }
        }
        int x = this.positionToAttack.m_123341_() + this.direction.x * 70;
        int z = this.positionToAttack.m_123343_() + this.direction.z * 70;
        for (ServerPlayer player : this.getNearbyPlayers()) {
            player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(Instances.Sounds.UNDEAD_ARMY_WAVE_STARTED, SoundSource.NEUTRAL, (double)x, player.m_20186_(), (double)z, 64.0f, 1.0f));
        }
        this.undeadToKill = Math.max(this.undeadToKill, 1);
    }

    private boolean shouldEntitiesBeHighlighted() {
        return this.ticksWaveActive >= TimeConverter.minutesToTicks((double)1.5) && this.ticksWaveActive % 100 == 0 && this.undeadKilled > this.undeadToKill / 2;
    }

    private boolean shouldWaveEndPrematurely() {
        boolean isOnlyFewUndeadLeft = (double)this.undeadKilled >= (double)this.undeadToKill * 0.8 && this.countUndeadEntitiesLeft() < 3;
        return isOnlyFewUndeadLeft && this.ticksWaveActive >= TimeConverter.minutesToTicks((double)2.5);
    }

    private void tryToEnchantEquipment(Mob monster) {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty((LivingEntity)monster);
        if (monster.m_21033_(EquipmentSlot.MAINHAND) && Random.tryChance((double)config.getEnchantedItemChance())) {
            monster.m_21008_(InteractionHand.MAIN_HAND, ItemHelper.enchantItem((ItemStack)monster.m_21205_(), (double)clampedRegionalDifficulty, (boolean)false));
        }
        for (ItemStack armor : monster.m_6168_()) {
            if (!Random.tryChance((double)(config.getEnchantedItemChance() / 2.0)) || (armor = ItemHelper.enchantItem((ItemStack)armor, (double)clampedRegionalDifficulty, (boolean)false)).getEquipmentSlot() == null) continue;
            monster.m_8061_(armor.getEquipmentSlot(), armor);
        }
    }

    private void equipWithDyedLeatherArmor(Mob monster) {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        double armorPieceChance = config.getArmorPieceChance();
        float armorPieceDropChance = 0.1f;
        this.equipWithArmorPieceIfPossible(monster, Items.f_42407_, "helmet", 1.0);
        this.equipWithArmorPieceIfPossible(monster, Items.f_42408_, "chestplate", armorPieceChance);
        this.equipWithArmorPieceIfPossible(monster, Items.f_42462_, "leggings", armorPieceChance);
        this.equipWithArmorPieceIfPossible(monster, Items.f_42463_, "boots", armorPieceChance);
        monster.m_21409_(EquipmentSlot.FEET, armorPieceDropChance);
        monster.m_21409_(EquipmentSlot.LEGS, armorPieceDropChance);
        monster.m_21409_(EquipmentSlot.CHEST, armorPieceDropChance);
        monster.m_21409_(EquipmentSlot.HEAD, armorPieceDropChance);
    }

    private void equipWithArmorPieceIfPossible(Mob monster, Item item, String registerName, double chance) {
        if (Random.tryChance((double)(1.0 - chance)) || monster instanceof TankEntity) {
            return;
        }
        ItemStack armorPiece = new ItemStack((ItemLike)item);
        this.setUndeadArmyColorAndName(armorPiece, registerName);
        ItemHelper.damageItem((ItemStack)armorPiece, (double)0.75);
        monster.m_21540_(armorPiece);
    }

    private void setUndeadArmyColorAndName(ItemStack armor, String registerName) {
        CompoundTag nbt = armor.m_41698_("display");
        nbt.m_128405_("color", 9595003);
        nbt.m_128359_("Name", "{\"translate\":\"majruszs_difficulty.items.undead_" + registerName + "\",\"italic\":false}");
        armor.m_41700_("display", (Tag)nbt);
    }

    private void rewardPlayers() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        for (Player player : this.level.m_8795_(this.getParticipantsPredicate())) {
            int i;
            Vec3 position = player.m_20182_();
            for (i = 0; i < config.getAmountOfVictoryExperience() / 4; ++i) {
                this.level.m_7967_((Entity)new ExperienceOrb((Level)this.level, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, 4));
            }
            if (player instanceof ServerPlayer) {
                Instances.UNDEAD_ARMY_DEFEATED_TRIGGER.trigger((ServerPlayer)player, this.currentWave);
            }
            if (!Instances.UNDEAD_ARMY_TREASURE_BAG.isAvailable()) continue;
            for (i = 0; i < config.getAmountOfVictoryTreasureBags(); ++i) {
                ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((ItemLike)Instances.UNDEAD_ARMY_TREASURE_BAG), (Player)player, (ServerLevel)this.level);
            }
        }
    }

    private void markAsUndeadArmyUnit(LivingEntity entity) {
        NBTHelper.saveBlockPos((CompoundTag)entity.getPersistentData(), (String)"UndeadArmyPosition", (BlockPos)this.positionToAttack);
    }

    private void spawnOnSkeletonHorse(Mob monster) {
        Level level = monster.f_19853_;
        SkeletonHorse skeletonHorse = (SkeletonHorse)EntityType.f_20525_.m_20615_(level);
        if (skeletonHorse == null) {
            return;
        }
        skeletonHorse.m_146762_(0);
        skeletonHorse.m_6034_(monster.m_20185_(), monster.m_20186_(), monster.m_20189_());
        level.m_7967_((Entity)skeletonHorse);
        monster.m_20329_((Entity)skeletonHorse);
        skeletonHorse.f_21345_.m_25352_(4, (Goal)new UndeadAttackPositionGoal((Mob)skeletonHorse, this.getAttackPosition(), 1.5, 20.0f, 3.0f));
        this.markAsUndeadArmyUnit((LivingEntity)skeletonHorse);
    }

    private void updateUndeadAIGoal(Mob monster) {
        float speedModifier = monster instanceof TankEntity ? 1.5f : 1.25f;
        monster.f_21345_.m_25352_(4, (Goal)new UndeadAttackPositionGoal(monster, this.getAttackPosition(), speedModifier, 20.0f, 3.0f));
        PathfinderMob pathfinderMob = (PathfinderMob)CommonHelper.castIfPossible(PathfinderMob.class, (Object)monster);
        if (pathfinderMob != null) {
            monster.f_21346_.m_148105_().removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof HurtByTargetGoal);
            monster.f_21346_.m_25352_(1, (Goal)new ForgiveUndeadArmyTargetGoal(pathfinderMob, new Class[0]));
        }
    }

    private void updateUndeadArmyBarVisibility() {
        HashSet currentPlayers = Sets.newHashSet((Iterable)this.bossInfo.m_8324_());
        List<ServerPlayer> validPlayers = this.getNearbyPlayers();
        for (ServerPlayer player : validPlayers) {
            if (currentPlayers.contains(player)) continue;
            this.bossInfo.m_6543_(player);
        }
        for (ServerPlayer player : currentPlayers) {
            if (validPlayers.contains(player)) continue;
            this.bossInfo.m_6539_(player);
        }
    }

    private AABB getAxisAligned(double range) {
        Vec3i vector = new Vec3i(range, range, range);
        return new AABB(this.getAttackPosition().m_141950_(vector), this.getAttackPosition().m_141952_(vector));
    }

    private Predicate<Mob> getUndeadParticipantsPredicate() {
        return monster -> monster.m_6084_() && UndeadArmy.doesEntityBelongToUndeadArmy((LivingEntity)monster);
    }

    private List<Mob> getNearbyUndeadArmy(double range) {
        return this.level.m_6443_(Mob.class, this.getAxisAligned(range), this.getUndeadParticipantsPredicate());
    }

    private int countNearbyUndeadArmy(double range) {
        return this.getNearbyUndeadArmy(range).size();
    }

    private Predicate<ServerPlayer> getParticipantsPredicate() {
        return player -> player.m_6084_() && RegistryHandler.UNDEAD_ARMY_MANAGER != null && RegistryHandler.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(player.m_20182_())) == this;
    }

    private List<ServerPlayer> getNearbyPlayers(double range) {
        return this.level.m_6443_(ServerPlayer.class, this.getAxisAligned(range), this.getParticipantsPredicate());
    }

    private List<ServerPlayer> getNearbyPlayers() {
        return this.level.m_8795_(this.getParticipantsPredicate());
    }

    private int countNearbyPlayers(double range) {
        return this.getNearbyPlayers(range).size();
    }

    private int countNearbyPlayers() {
        return this.getNearbyPlayers().size();
    }
}

