/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.mlib.MajruszLibrary;
import com.mlib.config.ConfigGroup;
import com.mlib.config.StringListConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.EntityType;

public class WaveMembersConfig
extends ConfigGroup {
    private final List<StringListConfig> listConfigs = new ArrayList<StringListConfig>();
    private int amountOfWaves = 0;

    public WaveMembersConfig(String name, String comment) {
        super(name, comment);
    }

    public StringListConfig createWaveConfig(String ... defaultValues) {
        ++this.amountOfWaves;
        String waveID = "wave_" + this.amountOfWaves;
        String waveComment = "Mobs in wave " + this.amountOfWaves + ".";
        return new StringListConfig(waveID, waveComment, false, defaultValues);
    }

    public void addWaveConfigs(StringListConfig ... waveConfigs) {
        this.configTypeList = new ArrayList<StringListConfig>(Arrays.asList(waveConfigs));
        this.listConfigs.addAll(Arrays.asList(waveConfigs));
    }

    public List<WaveMember> getWaveMembers(int waveNumber) {
        StringListConfig waveStringConfig = this.listConfigs.get(waveNumber - 1);
        ArrayList<WaveMember> waveMembers = new ArrayList<WaveMember>();
        for (String config : waveStringConfig.get()) {
            Optional optionalEntityType;
            Pattern pattern = Pattern.compile("(.*)-(.*) (.*)");
            Matcher matcher = pattern.matcher(config);
            if (!matcher.find() || !(optionalEntityType = EntityType.m_20632_((String)matcher.group(3))).isPresent()) continue;
            int minAmount = Integer.parseInt(matcher.group(1));
            int maxAmount = Integer.parseInt(matcher.group(2));
            WaveMember waveMember = new WaveMember();
            waveMember.amount = minAmount + MajruszLibrary.RANDOM.nextInt(maxAmount - minAmount + 1);
            waveMember.entityType = (EntityType)optionalEntityType.get();
            if (waveMember.amount <= 0) continue;
            waveMembers.add(waveMember);
        }
        return waveMembers;
    }

    public static class WaveMember {
        int amount;
        EntityType<?> entityType;
    }
}

