/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedBase;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class CreeperDamageReductionOnHurt
extends WhenDamagedBase {
    private static final String CONFIG_NAME = "CreeperExplosionReduction";
    private static final String CONFIG_COMMENT = "Makes all Creepers take less damage from other Creepers.";
    protected final DoubleConfig damageMultiplier;

    public CreeperDamageReductionOnHurt() {
        super(CONFIG_NAME, CONFIG_COMMENT, GameState.State.EXPERT);
        String multiplierComment = "Damage multiplier when Creepers attack Creeper.";
        this.damageMultiplier = new DoubleConfig("damage_multiplier", multiplierComment, false, 0.1, 0.0, 1.0);
        this.featureGroup.addConfig((IConfig)this.damageMultiplier);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        event.setAmount((float)((double)event.getAmount() * this.damageMultiplier.get()));
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return attacker instanceof Creeper && target instanceof Creeper && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

