/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.blocks.EndShardOre;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedBase;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class TriggerAllEndermansOnAttack
extends WhenDamagedBase {
    private static final String CONFIG_NAME = "EndermanAttack";
    private static final String CONFIG_COMMENT = "Makes all nearby enderman target player when it hits any of them.";

    public TriggerAllEndermansOnAttack() {
        super(CONFIG_NAME, CONFIG_COMMENT, GameState.State.MASTER);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        if (attacker != null) {
            EndShardOre.targetEndermansOnEntity(attacker, 250.0);
        }
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return attacker != null && target instanceof EnderMan && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

