/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.goals;

import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.mlib.CommonHelper;
import com.mlib.entities.EntityHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;

public class CreeperExplodeWallsGoal
extends Goal {
    private static final double MAXIMUM_START_DISTANCE = 19.0;
    private static final double MAXIMUM_EXPLODE_DISTANCE = 49.0;
    private static final double OFFSET = 16.0;
    private final Creeper creeper;
    private LivingEntity attackTarget;

    public CreeperExplodeWallsGoal(Creeper creeper) {
        this.creeper = creeper;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Player target = this.getNearestPlayer(this.creeper);
        return this.creeper.m_32310_() > 0 || target != null && this.creeper.m_20280_((Entity)target) < 19.0 * this.getDistanceMultiplier();
    }

    public void m_8056_() {
        this.creeper.m_21573_().m_26573_();
        this.attackTarget = this.getNearestPlayer(this.creeper);
    }

    public void m_8041_() {
        this.attackTarget = null;
    }

    public void m_8037_() {
        if (this.attackTarget == null || this.creeper.m_20280_((Entity)this.attackTarget) > 49.0 * this.getDistanceMultiplier()) {
            this.creeper.m_32283_(-1);
        } else {
            this.creeper.m_32283_(1);
        }
    }

    private double getDistanceMultiplier() {
        double sizeMultiplier = this.creeper instanceof CreeperlingEntity ? 0.6 : 1.0;
        double chargedMultiplier = this.creeper.m_7090_() ? 2.0 : 1.0;
        return sizeMultiplier * chargedMultiplier;
    }

    @Nullable
    private Player getNearestPlayer(Creeper creeper) {
        ServerLevel level = (ServerLevel)CommonHelper.castIfPossible(ServerLevel.class, (Object)creeper.f_19853_);
        if (level == null) {
            return null;
        }
        Predicate<Player> playerPredicate = player -> !EntityHelper.isOnCreativeMode((Player)player);
        List nearestPlayers = EntityHelper.getEntitiesInSphere(Player.class, (ServerLevel)level, (Entity)creeper, (double)16.0, playerPredicate);
        Player nearestPlayer = null;
        for (Player player2 : nearestPlayers) {
            if (nearestPlayer != null && !(creeper.m_20280_((Entity)player2) < creeper.m_20280_((Entity)nearestPlayer))) continue;
            nearestPlayer = player2;
        }
        return nearestPlayer;
    }
}

