/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.effects.BleedingEffect;
import com.mlib.CommonHelper;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.effects.EffectHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BandageItem
extends Item {
    private static final String TOOLTIP_TRANSLATION_KEY_1 = "item.majruszs_difficulty.bandage.item_tooltip1";
    private static final String TOOLTIP_TRANSLATION_KEY_2 = "item.majruszs_difficulty.bandage.item_tooltip2";
    protected final ConfigGroup configGroup;
    protected final AvailabilityConfig isAlwaysUsable;
    protected final DurationConfig effectDuration;
    protected final IntegerConfig effectAmplifier;

    public BandageItem() {
        this("Bandage", 0, Rarity.COMMON);
    }

    public BandageItem(String name, int defaultAmplifier, Rarity rarity) {
        super(new Item.Properties().m_41487_(16).m_41491_(Instances.ITEM_GROUP).m_41497_(rarity));
        this.configGroup = new ConfigGroup(name, "Configuration for " + name + " item.");
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)this.configGroup);
        String usableComment = "Is " + name + " always usable? If not player can only use " + name + " when it is bleeding.";
        String durationComment = "Duration in seconds of Regeneration effect.";
        String amplifierComment = "Level/amplifier of Regeneration effect.";
        this.isAlwaysUsable = new AvailabilityConfig("is_always_usable", usableComment, false, true);
        this.effectDuration = new DurationConfig("regeneration_duration", durationComment, false, 4.0, 1.0, 120.0);
        this.effectAmplifier = new IntegerConfig("regeneration_amplifier", amplifierComment, false, defaultAmplifier, 0, 10);
        this.configGroup.addConfigs(new IConfig[]{this.isAlwaysUsable, this.effectDuration, this.effectAmplifier});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        this.useIfPossible(itemStack, player, (LivingEntity)player);
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        MajruszsHelper.addAdvancedTranslatableTexts(tooltip, flag, TOOLTIP_TRANSLATION_KEY_1, TOOLTIP_TRANSLATION_KEY_2);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (!(itemStack.m_41720_() instanceof BandageItem)) {
            return;
        }
        BandageItem bandage = (BandageItem)itemStack.m_41720_();
        if (bandage.useIfPossible(event.getItemStack(), event.getPlayer(), (LivingEntity)event.getTarget())) {
            Villager villager = (Villager)CommonHelper.castIfPossible(Villager.class, (Object)event.getTarget());
            if (villager != null) {
                BandageItem.increaseReputation(event.getPlayer(), villager);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static void increaseReputation(Player player, Villager villager) {
        villager.m_35517_().m_26191_(player.m_142081_(), GossipType.MINOR_POSITIVE, 5);
    }

    public boolean isAlwaysUsable() {
        return this.isAlwaysUsable.isEnabled();
    }

    public int getRegenerationDuration() {
        return this.effectDuration.getDuration();
    }

    public int getRegenerationAmplifier() {
        return this.effectAmplifier.get();
    }

    protected void applyEffects(LivingEntity target) {
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (MobEffect)MobEffects.f_19605_, (int)this.getRegenerationDuration(), (int)this.getRegenerationAmplifier());
    }

    private boolean useIfPossible(ItemStack bandage, Player player, LivingEntity target) {
        if (!this.couldBeUsedOn(target, bandage)) {
            return false;
        }
        if (!player.m_150110_().f_35937_) {
            bandage.m_41774_(1);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)bandage.m_41720_()));
        this.removeBleeding(target, player);
        this.applyEffects(target);
        target.f_19853_.m_5594_(null, target.m_142538_(), SoundEvents.f_12019_, SoundSource.AMBIENT, 1.0f, 1.0f);
        return true;
    }

    private boolean couldBeUsedOn(LivingEntity target, ItemStack bandage) {
        boolean isBandage = bandage.m_41720_() instanceof BandageItem;
        boolean targetHasRegeneration = target.m_21023_(MobEffects.f_19605_);
        return isBandage && (this.isAlwaysUsable() && !targetHasRegeneration || target.m_21023_((MobEffect)Instances.BLEEDING));
    }

    private void removeBleeding(LivingEntity target, Player causer) {
        BleedingEffect bleeding = Instances.BLEEDING;
        if (target.m_21023_((MobEffect)bleeding) && causer instanceof ServerPlayer) {
            Instances.BANDAGE_TRIGGER.trigger((ServerPlayer)causer, this, target.equals((Object)causer));
        }
        target.m_21195_((MobEffect)bleeding);
        target.m_6234_((MobEffect)bleeding);
    }
}

