/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.google.common.collect.ImmutableMultimap;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.items.AttributeArmorItem;
import com.majruszs_difficulty.items.CustomArmorMaterial;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HermesBootsItem
extends AttributeArmorItem {
    protected final DoubleConfig movementSpeedBonus;
    protected final ConfigGroup configGroup;

    public HermesBootsItem() {
        super(CustomArmorMaterial.HERMES, EquipmentSlot.FEET, new Item.Properties().m_41491_(Instances.ITEM_GROUP).m_41497_(Rarity.UNCOMMON));
        String comment = "Movement speed extra multiplier. (requires game/world restart!)";
        this.movementSpeedBonus = new DoubleConfig("movement_speed_bonus", comment, true, 0.25, 0.0, 5.0);
        this.configGroup = new ConfigGroup("HermesBoots", "Hermes Boots item configuration.");
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)this.configGroup);
        this.configGroup.addConfig((IConfig)this.movementSpeedBonus);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation textureLocation = MajruszsDifficulty.getLocation("textures/models/armor/hermes_layer.png");
        return textureLocation.toString();
    }

    @Override
    protected void updateAttributes(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("dbe472cb-df52-44ab-ab38-01b00e24f649"), "HermesBootsMovementSpeedBonus", this.movementSpeedBonus.get().doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE));
    }
}

