/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.loot_modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.majruszs_difficulty.GameState;
import com.mlib.Random;
import com.mlib.loot_modifiers.LootHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class DoubleLoot
extends LootModifier {
    private final double normalModeChance;
    private final double expertModeChance;
    private final double masterModeChance;
    private final List<Item> forbiddenItemsToDuplicate;

    public DoubleLoot(LootItemCondition[] conditions, double normalChance, double expertChance, double masterChance, List<Item> forbiddenItems) {
        super(conditions);
        this.normalModeChance = normalChance;
        this.expertModeChance = expertChance;
        this.masterModeChance = masterChance;
        this.forbiddenItemsToDuplicate = forbiddenItems;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        double chance = GameState.getValueDependingOnCurrentGameState(this.normalModeChance, this.expertModeChance, this.masterModeChance);
        if (Random.tryChance((double)chance)) {
            Entity entity = (Entity)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81455_);
            if (generatedLoot.size() > 0 && entity != null) {
                this.sendParticless(entity);
            }
            return this.doubleLoot(generatedLoot);
        }
        return generatedLoot;
    }

    protected void sendParticless(Entity entity) {
        if (!(entity.f_19853_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)entity.f_19853_;
        for (int i = 0; i < 8; ++i) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), 1, 0.5, 0.5, 0.5, 0.5);
        }
    }

    protected List<ItemStack> doubleLoot(List<ItemStack> generatedLoot) {
        ArrayList<ItemStack> doubledLoot = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            boolean isItemForbidden = this.isForbidden(itemStack.m_41720_());
            for (int i = 0; !(i >= 2 || i >= 1 && isItemForbidden); ++i) {
                doubledLoot.add(itemStack);
            }
        }
        return doubledLoot;
    }

    protected boolean isForbidden(Item item) {
        for (Item forbidden : this.forbiddenItemsToDuplicate) {
            if (!forbidden.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DoubleLoot> {
        public DoubleLoot read(ResourceLocation name, JsonObject object, LootItemCondition[] conditions) {
            double normalModeChance = GsonHelper.m_13915_((JsonObject)object, (String)"normal_chance");
            double expertModeChance = GsonHelper.m_13915_((JsonObject)object, (String)"expert_chance");
            double masterModeChance = GsonHelper.m_13915_((JsonObject)object, (String)"master_chance");
            JsonArray items = GsonHelper.m_13933_((JsonObject)object, (String)"forbidden_items");
            ArrayList<Item> forbiddenItemsToDuplicate = new ArrayList<Item>();
            for (int i = 0; i < items.size(); ++i) {
                JsonObject item = items.get(i).getAsJsonObject();
                forbiddenItemsToDuplicate.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.get("name").getAsString())));
            }
            return new DoubleLoot(conditions, normalModeChance, expertModeChance, masterModeChance, forbiddenItemsToDuplicate);
        }

        public JsonObject write(DoubleLoot instance) {
            return null;
        }
    }
}

