/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.commands;

import com.mlib.commands.BaseCommand;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;

public class CommandManager {
    protected CommandDispatcher<CommandSourceStack> dispatcher;

    public CommandManager(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected Command<CommandSourceStack> getCommand(IExecutable executable) {
        return context -> executable.execute((CommandContext<CommandSourceStack>)context, (CommandSourceStack)context.getSource());
    }

    protected void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        this.dispatcher.register(builder);
    }

    public void register(BaseCommand.Data data, IExecutable executable) {
        LiteralArgumentBuilder<CommandSourceStack> commandBuilder = data.command;
        for (Predicate<CommandSourceStack> requirement : data.requirements) {
            commandBuilder.requires(requirement);
        }
        if (!data.arguments.isEmpty()) {
            ArgumentBuilder argumentBuilder = data.arguments.get(data.arguments.size() - 1);
            argumentBuilder = argumentBuilder.executes(this.getCommand(executable));
            for (int i = data.arguments.size() - 2; i >= 0; --i) {
                ArgumentBuilder<CommandSourceStack, ?> nextArgumentBuilder = data.arguments.get(i);
                argumentBuilder = nextArgumentBuilder.then(argumentBuilder);
            }
            this.dispatcher.register((LiteralArgumentBuilder)commandBuilder.then(argumentBuilder));
        } else {
            this.dispatcher.register((LiteralArgumentBuilder)commandBuilder.executes(this.getCommand(executable)));
        }
    }

    public void register(LiteralArgumentBuilder<CommandSourceStack> argument1, ArgumentBuilder<CommandSourceStack, ?> argument2, ArgumentBuilder<CommandSourceStack, ?> argument3, IExecutable executable) {
        this.register(new BaseCommand.Data(argument1, argument2, argument3), executable);
    }

    public void register(LiteralArgumentBuilder<CommandSourceStack> argument1, ArgumentBuilder<CommandSourceStack, ?> argument2, ArgumentBuilder<CommandSourceStack, ?> argument3, Predicate<CommandSourceStack> requirement, IExecutable executable) {
        this.register(new BaseCommand.Data(requirement, argument1, argument2, argument3), executable);
    }

    public void register(LiteralArgumentBuilder<CommandSourceStack> argument1, ArgumentBuilder<CommandSourceStack, ?> argument2, IExecutable executable) {
        this.register(new BaseCommand.Data(argument1, argument2), executable);
    }

    public void register(LiteralArgumentBuilder<CommandSourceStack> argument1, ArgumentBuilder<CommandSourceStack, ?> argument2, Predicate<CommandSourceStack> requirement, IExecutable executable) {
        this.register(new BaseCommand.Data(requirement, argument1, argument2), executable);
    }

    public void register(LiteralArgumentBuilder<CommandSourceStack> argument, IExecutable executable) {
        this.register(new BaseCommand.Data(argument, new ArgumentBuilder[0]), executable);
    }

    public void register(LiteralArgumentBuilder<CommandSourceStack> argument, Predicate<CommandSourceStack> requirement, IExecutable executable) {
        this.register(new BaseCommand.Data(requirement, argument, new ArgumentBuilder[0]), executable);
    }

    @FunctionalInterface
    public static interface IExecutable {
        public int execute(CommandContext<CommandSourceStack> var1, CommandSourceStack var2);
    }
}

