/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.enchantments;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.DeferredRegister;

public abstract class ExtendedEnchantment
extends Enchantment {
    private static final int DISABLE_ENCHANTMENT_VALUE = 9001;
    protected final String registerName;
    private int differenceBetweenMinimumAndMaximum = 10;
    private int maximumEnchantmentLevel = 1;
    private MinimumEnchantabilityCalculator minimumEnchantabilityCalculator = level -> level;

    protected ExtendedEnchantment(String registerName, Enchantment.Rarity rarity, EnchantmentCategory enchantmentCategory, EquipmentSlot[] equipmentSlots) {
        super(rarity, enchantmentCategory, equipmentSlots);
        this.registerName = registerName;
    }

    protected ExtendedEnchantment(String registerName, Enchantment.Rarity rarity, EnchantmentCategory enchantmentCategory, EquipmentSlot equipmentSlot) {
        this(registerName, rarity, enchantmentCategory, new EquipmentSlot[]{equipmentSlot});
    }

    public int m_6586_() {
        return this.maximumEnchantmentLevel;
    }

    public int m_6183_(int level) {
        return this.isDisabled() ? 9001 : this.minimumEnchantabilityCalculator.getMinimumLevel(level);
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + this.differenceBetweenMinimumAndMaximum;
    }

    public boolean m_6081_(ItemStack stack) {
        return !this.isDisabled() && super.m_6081_(stack);
    }

    public boolean m_6594_() {
        return !this.isDisabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return !this.isDisabled() && super.m_6592_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return !this.isDisabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return !this.isDisabled() && super.isAllowedOnBooks();
    }

    public void register(DeferredRegister<Enchantment> enchantments) {
        enchantments.register(this.registerName, () -> this);
    }

    public int getEnchantmentLevel(ItemStack itemStack) {
        return EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)itemStack);
    }

    public int getEnchantmentLevel(LivingEntity entity) {
        return EnchantmentHelper.m_44836_((Enchantment)this, (LivingEntity)entity);
    }

    public boolean hasEnchantment(ItemStack itemStack) {
        return this.getEnchantmentLevel(itemStack) > 0;
    }

    public boolean hasEnchantment(LivingEntity entity) {
        return this.getEnchantmentLevel(entity) > 0;
    }

    public boolean increaseEnchantmentLevel(ItemStack itemStack) {
        int enchantmentLevel = this.getEnchantmentLevel(itemStack);
        if (enchantmentLevel >= this.m_6586_()) {
            return false;
        }
        if (enchantmentLevel == 0) {
            itemStack.m_41663_((Enchantment)this, 1);
        } else {
            ListTag nbt = itemStack.m_41785_();
            for (int i = 0; i < nbt.size(); ++i) {
                CompoundTag enchantmentData = nbt.m_128728_(i);
                String enchantmentID = enchantmentData.m_128461_("id");
                if (!enchantmentID.contains(this.registerName)) continue;
                enchantmentData.m_128405_("lvl", enchantmentLevel + 1);
                break;
            }
            itemStack.m_41700_("Enchantments", (Tag)nbt);
        }
        return true;
    }

    public int getEnchantmentSum(Iterable<ItemStack> itemStacks) {
        int sum = 0;
        if (itemStacks != null) {
            for (ItemStack itemStack : itemStacks) {
                sum += EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)itemStack);
            }
        }
        return sum;
    }

    public int getEnchantmentSum(LivingEntity livingEntity, EquipmentSlot[] slots) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (EquipmentSlot slotType : slots) {
            itemStackList.add(livingEntity.m_6844_(slotType));
        }
        return this.getEnchantmentSum(itemStackList);
    }

    protected abstract boolean isDisabled();

    protected void setDifferenceBetweenMinimumAndMaximum(int differenceInLevels) {
        this.differenceBetweenMinimumAndMaximum = Math.max(1, differenceInLevels);
    }

    protected void setMinimumEnchantabilityCalculator(MinimumEnchantabilityCalculator minimumEnchantabilityCalculator) {
        this.minimumEnchantabilityCalculator = minimumEnchantabilityCalculator;
    }

    protected void setMaximumEnchantmentLevel(int enchantmentLevel) {
        this.maximumEnchantmentLevel = Math.max(1, enchantmentLevel);
    }

    @FunctionalInterface
    protected static interface MinimumEnchantabilityCalculator {
        public int getMinimumLevel(int var1);
    }
}

