/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.config.GameStateEnumConfig;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class GameStateConfig {
    protected final StringListConfig entitiesStartingExpertMode;
    protected final StringListConfig entitiesStartingMasterMode;
    protected final StringListConfig dimensionsStartingExpertMode;
    protected final StringListConfig dimensionsStartingMasterMode;
    protected final AvailabilityConfig enteringAnyDimensionStartsExpertMode;
    protected final GameStateEnumConfig defaultGameState;

    public GameStateConfig() {
        String entitiesExpertComment = "List of entities which start Expert Mode after killing them. (at least one)";
        this.entitiesStartingExpertMode = new StringListConfig("entities_expert", entitiesExpertComment, false, new String[]{"none"});
        String entitiesMasterComment = "List of entities which start Master Mode after killing them.";
        this.entitiesStartingMasterMode = new StringListConfig("entities_master", entitiesMasterComment, false, new String[]{"minecraft:ender_dragon"});
        String dimensionsExpertComment = "List of dimensions that start Expert Mode when a player enters it for the first time. (ignored when any_dimension_expert is set to true)";
        this.dimensionsStartingExpertMode = new StringListConfig("dimensions_expert", dimensionsExpertComment, false, new String[]{"minecraft:the_nether"});
        String dimensionsMasterComment = "List of dimensions that start Master Mode when a player enters it for the first time.";
        this.dimensionsStartingMasterMode = new StringListConfig("dimensions_master", dimensionsMasterComment, false, new String[]{"none"});
        String anyDimensionComment = "Should entering any dimension start Expert Mode?";
        this.enteringAnyDimensionStartsExpertMode = new AvailabilityConfig("any_dimension_expert", anyDimensionComment, false, true);
        String defaultComment = "Game state that is always set at the beginning of the game.";
        this.defaultGameState = new GameStateEnumConfig("default_game_state", defaultComment, false, GameState.State.NORMAL);
        MajruszsDifficulty.STATE_GROUP.addConfigs(new IConfig[]{this.entitiesStartingExpertMode, this.entitiesStartingMasterMode, this.dimensionsStartingExpertMode, this.dimensionsStartingMasterMode, this.enteringAnyDimensionStartsExpertMode, this.defaultGameState});
    }

    public boolean shouldDimensionStartExpertMode(ResourceLocation dimensionLocation) {
        return this.enteringAnyDimensionStartsExpertMode.isEnabled() || this.dimensionsStartingExpertMode.contains(dimensionLocation.toString());
    }

    public boolean shouldDimensionStartMasterMode(ResourceLocation dimensionLocation) {
        return this.dimensionsStartingMasterMode.contains(dimensionLocation.toString());
    }

    public boolean shouldKillingEntityStartExpertMode(@Nullable ResourceLocation entityLocation) {
        return entityLocation != null && this.entitiesStartingExpertMode.contains(entityLocation.toString());
    }

    public boolean shouldKillingEntityStartMasterMode(@Nullable ResourceLocation entityLocation) {
        return entityLocation != null && this.entitiesStartingMasterMode.contains(entityLocation.toString());
    }

    public GameState.State getDefaultState() {
        return this.defaultGameState.get();
    }
}

