/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty;

import com.majruszs_difficulty.GameDataSaver;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.PacketHandler;
import com.majruszs_difficulty.RegistryHandlerClient;
import com.majruszs_difficulty.commands.CommandsHelper;
import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.majruszs_difficulty.entities.EliteSkeletonEntity;
import com.majruszs_difficulty.entities.GiantEntity;
import com.majruszs_difficulty.entities.ParasiteEntity;
import com.majruszs_difficulty.entities.PillagerWolfEntity;
import com.majruszs_difficulty.entities.TankEntity;
import com.majruszs_difficulty.features.treasure_bag.TreasureBagManager;
import com.majruszs_difficulty.features.undead_army.ReloadUndeadArmyGoals;
import com.majruszs_difficulty.features.undead_army.UndeadArmyManager;
import com.majruszs_difficulty.generation.OreGeneration;
import com.majruszs_difficulty.items.AttributeArmorItem;
import com.majruszs_difficulty.items.FakeItem;
import com.mlib.commands.IRegistrableCommand;
import com.mlib.items.SpawnEggFactory;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.server.ServerLifecycleEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryHandler {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"majruszs_difficulty");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"majruszs_difficulty");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"majruszs_difficulty");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"majruszs_difficulty");
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"majruszs_difficulty");
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"majruszs_difficulty");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"majruszs_difficulty");
    public static UndeadArmyManager UNDEAD_ARMY_MANAGER;
    public static GameDataSaver GAME_DATA_SAVER;

    public static void init() {
        FMLJavaModLoadingContext loadingContext = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = loadingContext.getModEventBus();
        RegistryHandler.registerEverything(modEventBus);
        modEventBus.addListener(RegistryHandler::setup);
        modEventBus.addListener(RegistryHandler::setupClient);
        modEventBus.addListener(RegistryHandler::setupEntities);
        modEventBus.addListener(PacketHandler::registerPacket);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(RegistryHandler::onTextureStitch));
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(RegistryHandler::onLoadingLevel);
        forgeEventBus.addListener(RegistryHandler::onSavingLevel);
        forgeEventBus.addListener(RegistryHandler::onServerStart);
        forgeEventBus.addListener(RegistryHandler::registerCommands);
    }

    private static void registerEntities(IEventBus modEventBus) {
        ENTITIES.register("giant", () -> GiantEntity.type);
        ENTITIES.register("pillager_wolf", () -> PillagerWolfEntity.type);
        ENTITIES.register("elite_skeleton", () -> EliteSkeletonEntity.type);
        ENTITIES.register("creeperling", () -> CreeperlingEntity.type);
        ENTITIES.register("parasite", () -> ParasiteEntity.type);
        ENTITIES.register("tank", () -> TankEntity.type);
        ENTITIES.register(modEventBus);
    }

    private static void registerSpawnEggs() {
        SpawnEggFactory.setDefaultItemGroup((CreativeModeTab)Instances.ITEM_GROUP);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"giant_spawn_egg", GiantEntity.type, (int)44975, (int)7969893);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"pillager_wolf_spawn_egg", PillagerWolfEntity.type, (int)0x959B9B, (int)5451574);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"illusioner_spawn_egg", (EntityType)EntityType.f_20459_, (int)1268375, (int)0x959B9B);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"elite_skeleton_spawn_egg", EliteSkeletonEntity.type, (int)0xC1C1C1, (int)16664653);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"creeperling_spawn_egg", CreeperlingEntity.type, (int)894731, (int)0);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"parasite_spawn_egg", ParasiteEntity.type, (int)0x161616, (int)9725844);
        SpawnEggFactory.createRegistrySpawnEgg(ITEMS, (String)"tank_spawn_egg", TankEntity.type, (int)0xC1C1C1, (int)0x949494);
    }

    private static void registerFakeItems(String ... registerNames) {
        for (String registerName : registerNames) {
            ITEMS.register("advancement_" + registerName, FakeItem::new);
        }
    }

    private static void registerFakeItems() {
        RegistryHandler.registerFakeItems("normal", "expert", "master", "bleeding");
    }

    private static void registerTreasureBags() {
        Instances.UNDEAD_ARMY_TREASURE_BAG.register();
        Instances.ELDER_GUARDIAN_TREASURE_BAG.register();
        Instances.WITHER_TREASURE_BAG.register();
        Instances.ENDER_DRAGON_TREASURE_BAG.register();
        Instances.FISHING_TREASURE_BAG.register();
        Instances.PILLAGER_TREASURE_BAG.register();
    }

    private static void registerItems(IEventBus modEventBus) {
        ITEMS.register("wither_sword", () -> Instances.WITHER_SWORD);
        ITEMS.register("hermes_boots", () -> Instances.HERMES_BOOTS_ITEM);
        ITEMS.register("end_shard", () -> Instances.END_SHARD_ITEM);
        ITEMS.register("end_ingot", () -> Instances.END_INGOT_ITEM);
        ITEMS.register("end_sword", () -> Instances.END_SWORD_ITEM);
        ITEMS.register("end_shovel", () -> Instances.END_SHOVEL_ITEM);
        ITEMS.register("end_pickaxe", () -> Instances.END_PICKAXE_ITEM);
        ITEMS.register("end_axe", () -> Instances.END_AXE_ITEM);
        ITEMS.register("end_hoe", () -> Instances.END_HOE_ITEM);
        ITEMS.register("end_helmet", () -> Instances.END_HELMET_ITEM);
        ITEMS.register("end_chestplate", () -> Instances.END_CHESTPLATE_ITEM);
        ITEMS.register("end_leggings", () -> Instances.END_LEGGINGS_ITEM);
        ITEMS.register("end_boots", () -> Instances.END_BOOTS_ITEM);
        ITEMS.register("end_shard_locator", () -> Instances.END_SHARD_LOCATOR_ITEM);
        ITEMS.register("tattered_cloth", () -> Instances.TATTERED_CLOTH_ITEM);
        ITEMS.register("undead_battle_standard", () -> Instances.BATTLE_STANDARD_ITEM);
        ITEMS.register("bandage", () -> Instances.BANDAGE_ITEM);
        ITEMS.register("golden_bandage", () -> Instances.GOLDEN_BANDAGE_ITEM);
        ITEMS.register("recall_potion", () -> Instances.RECALL_POTION_ITEM);
        ITEMS.register("ocean_shield", () -> Instances.OCEAN_SHIELD_ITEM);
        RegistryHandler.registerTreasureBags();
        RegistryHandler.registerSpawnEggs();
        RegistryHandler.registerFakeItems();
        ITEMS.register(modEventBus);
    }

    private static void registerBlocks(IEventBus modEventBus) {
        BLOCKS.register("end_shard_ore", () -> Instances.END_SHARD_ORE);
        ITEMS.register("end_shard_ore", () -> Instances.END_SHARD_ORE_ITEM);
        BLOCKS.register("end_block", () -> Instances.END_BLOCK);
        ITEMS.register("end_block", () -> Instances.END_BLOCK_ITEM);
        BLOCKS.register("infested_end_stone", () -> Instances.INFESTED_END_STONE);
        ITEMS.register("infested_end_stone", () -> Instances.INFESTED_END_STONE_ITEM);
        BLOCKS.register(modEventBus);
    }

    private static void registerSounds(IEventBus modEventBus) {
        SOUNDS.register("undead_army.approaching", () -> Instances.Sounds.UNDEAD_ARMY_APPROACHING);
        SOUNDS.register("undead_army.wave_started", () -> Instances.Sounds.UNDEAD_ARMY_WAVE_STARTED);
        SOUNDS.register(modEventBus);
    }

    private static void registerEffects(IEventBus modEventBus) {
        EFFECTS.register("bleeding", () -> Instances.BLEEDING);
        EFFECTS.register("bleeding_immunity", () -> Instances.BLEEDING_IMMUNITY);
        EFFECTS.register("infested", () -> Instances.INFESTED);
        EFFECTS.register(modEventBus);
    }

    private static void registerParticles(IEventBus modEventBus) {
        PARTICLES.register("blood_particle", () -> Instances.BLOOD_PARTICLE);
        PARTICLES.register(modEventBus);
    }

    private static void registerStructures(IEventBus modEventBus) {
    }

    private static void registerEverything(IEventBus modEventBus) {
        RegistryHandler.registerEntities(modEventBus);
        RegistryHandler.registerBlocks(modEventBus);
        RegistryHandler.registerItems(modEventBus);
        RegistryHandler.registerSounds(modEventBus);
        RegistryHandler.registerEffects(modEventBus);
        RegistryHandler.registerParticles(modEventBus);
        RegistryHandler.registerStructures(modEventBus);
    }

    private static void setupClient(FMLClientSetupEvent event) {
        RegistryHandlerClient.setup();
    }

    private static void setupEntities(EntityAttributeCreationEvent event) {
        event.put(GiantEntity.type, GiantEntity.getAttributeMap());
        event.put(PillagerWolfEntity.type, PillagerWolfEntity.getAttributeMap());
        event.put(EliteSkeletonEntity.type, EliteSkeletonEntity.getAttributeMap());
        event.put(CreeperlingEntity.type, CreeperlingEntity.getAttributeMap());
        event.put(ParasiteEntity.type, ParasiteEntity.getAttributeMap());
        event.put(TankEntity.type, TankEntity.getAttributeMap());
    }

    private static void setup(FMLCommonSetupEvent event) {
        SpawnPlacements.m_21754_(GiantEntity.type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_(PillagerWolfEntity.type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(EliteSkeletonEntity.type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_(CreeperlingEntity.type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        SpawnPlacements.m_21754_(ParasiteEntity.type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        SpawnPlacements.m_21754_(TankEntity.type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33017_);
        OreGeneration.registerOres();
        AttributeArmorItem.updateAllItemsAttributes();
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        for (IRegistrableCommand command : CommandsHelper.COMMANDS) {
            command.register(event.getDispatcher());
        }
    }

    private static void onServerStart(ServerLifecycleEvent event) {
        MinecraftServer server = event.getServer();
        if (UNDEAD_ARMY_MANAGER != null) {
            UNDEAD_ARMY_MANAGER.updateWorld(server.m_129880_(ServerLevel.f_46428_));
        }
        TreasureBagManager.addTreasureBagTo(EntityType.f_20563_, Instances.ELDER_GUARDIAN_TREASURE_BAG, false);
        TreasureBagManager.addTreasureBagTo(EntityType.f_20496_, Instances.WITHER_TREASURE_BAG, false);
        TreasureBagManager.addTreasureBagTo(EntityType.f_20565_, Instances.ENDER_DRAGON_TREASURE_BAG, false);
    }

    public static void onLoadingLevel(WorldEvent.Load event) {
        ServerLevel level = RegistryHandler.getOverworld(event.getWorld());
        if (level == null) {
            return;
        }
        DimensionDataStorage manager = level.m_8895_();
        UNDEAD_ARMY_MANAGER = (UndeadArmyManager)manager.m_164861_(nbt -> UndeadArmyManager.load(nbt, level), () -> new UndeadArmyManager(level), "undead_army");
        UNDEAD_ARMY_MANAGER.updateWorld(level);
        GAME_DATA_SAVER = (GameDataSaver)manager.m_164861_(GameDataSaver::load, GameDataSaver::new, "majruszs_difficulty");
        ReloadUndeadArmyGoals.resetTimer();
    }

    public static void onSavingLevel(WorldEvent.Save event) {
        ServerLevel level = RegistryHandler.getOverworld(event.getWorld());
        if (level == null) {
            return;
        }
        GAME_DATA_SAVER.m_77762_();
        UNDEAD_ARMY_MANAGER.m_77762_();
    }

    @Nullable
    private static ServerLevel getOverworld(LevelAccessor levelAccessor) {
        MinecraftServer minecraftServer = levelAccessor.m_142572_();
        if (minecraftServer == null) {
            return null;
        }
        ServerLevel overworld = minecraftServer.m_129880_(Level.f_46428_);
        return levelAccessor.equals(overworld) ? overworld : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onTextureStitch(TextureStitchEvent.Pre event) {
        TextureAtlas map = event.getAtlas();
        if (InventoryMenu.f_39692_.equals((Object)map.m_118330_())) {
            event.addSprite(RegistryHandlerClient.OCEAN_SHIELD_MATERIAL.m_119203_());
        }
    }
}

