/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.effects;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.config.GameStateIntegerConfig;
import com.mlib.CommonHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import com.mlib.effects.EffectHelper;
import com.mlib.time.TimeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BleedingEffect
extends MobEffect {
    protected final ConfigGroup bleedingGroup;
    protected final DoubleConfig damage;
    protected final DurationConfig baseCooldown;
    protected final DoubleConfig armorChanceReduction;
    protected final GameStateIntegerConfig amplifier;
    protected final StringListConfig entitiesBlackList;

    public BleedingEffect() {
        super(MobEffectCategory.HARMFUL, -2271915);
        String damageComment = "Damage dealt by Bleeding every tick.";
        this.damage = new DoubleConfig("damage", damageComment, false, 1.0, 0.0, 20.0);
        String cooldownComment = "Cooldown between taking damage.";
        this.baseCooldown = new DurationConfig("cooldown", cooldownComment, false, 4.0, 0.0, 20.0);
        String armorComment = "Chance reduction per each armor piece.";
        this.armorChanceReduction = new DoubleConfig("armor_reduction", armorComment, false, 0.2, 0.0, 0.25);
        String amplifierComment = "Bleeding amplifier.";
        this.amplifier = new GameStateIntegerConfig("amplifier", amplifierComment, 0, 1, 2, 0, 10);
        String blackComment = "List of entities who are immune to Bleeding effect. (only human-like mobs and animals)";
        this.entitiesBlackList = new StringListConfig("black_list", blackComment, false, new String[]{"minecraft:skeleton_horse"});
        this.bleedingGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("Bleeding", "Bleeding potion effect."));
        this.bleedingGroup.addConfigs(new IConfig[]{this.damage, this.baseCooldown, this.armorChanceReduction, this.amplifier, this.entitiesBlackList});
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        float damageAmount = this.damage.get().floatValue();
        BleedingMobEffectInstance effectInstance = (BleedingMobEffectInstance)((Object)CommonHelper.castIfPossible(BleedingMobEffectInstance.class, (Object)entity.m_21124_((MobEffect)this)));
        if (effectInstance != null) {
            Vec3 motion = entity.m_20184_();
            entity.m_6469_((DamageSource)new EntityBleedingDamageSource(effectInstance.damageSourceEntity), damageAmount);
            entity.m_20256_(motion);
        } else {
            entity.m_6469_(Instances.BLEEDING_SOURCE, damageAmount);
        }
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
    }

    public boolean m_6584_(int duration, int amplifier) {
        int cooldown = Math.max(4, this.baseCooldown.getDuration() >> amplifier);
        return duration % cooldown == 0;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingUpdateEvent event) {
        BleedingEffect bleeding = Instances.BLEEDING;
        LivingEntity entity = event.getEntityLiving();
        if (TimeHelper.hasServerTicksPassed((int)5) && entity.m_21023_((MobEffect)bleeding)) {
            int amountOfParticles = EffectHelper.getEffectAmplifier((LivingEntity)entity, (MobEffect)bleeding) + 3;
            bleeding.spawnParticles(entity, amountOfParticles);
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        BleedingEffect bleeding = Instances.BLEEDING;
        LivingEntity entity = event.getEntityLiving();
        if (entity.m_21023_((MobEffect)bleeding)) {
            bleeding.spawnParticles(event.getEntityLiving(), 100);
        }
    }

    public static boolean isBleedingSource(DamageSource damageSource) {
        return damageSource.f_19326_.equals(Instances.BLEEDING_SOURCE.f_19326_);
    }

    private void spawnParticles(LivingEntity entity, int amountOfParticles) {
        ServerLevel level = (ServerLevel)CommonHelper.castIfPossible(ServerLevel.class, (Object)entity.f_19853_);
        if (level != null) {
            level.m_8767_((ParticleOptions)Instances.BLOOD_PARTICLE, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), amountOfParticles, 0.125, 0.5, 0.125, 0.05);
        }
    }

    public int getAmplifier() {
        return this.amplifier.getCurrentGameStateValue();
    }

    public boolean mayBleed(@Nullable Entity entity) {
        return (MajruszsHelper.isAnimal(entity) || MajruszsHelper.isHuman(entity)) && !this.isBlackListed(entity);
    }

    private boolean isBlackListed(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        EntityType entityType = entity.m_6095_();
        ResourceLocation entityLocation = entityType.getRegistryName();
        return entityLocation != null && this.entitiesBlackList.contains(entityLocation.toString());
    }

    public double getChanceMultiplierDependingOnArmor(LivingEntity entity) {
        double chance = 1.0;
        for (ItemStack armorPiece : entity.m_6168_()) {
            if (armorPiece.m_41619_()) continue;
            chance -= this.armorChanceReduction.get().doubleValue();
        }
        return chance;
    }

    public static class BleedingMobEffectInstance
    extends MobEffectInstance {
        @Nullable
        protected final Entity damageSourceEntity;

        public BleedingMobEffectInstance(int duration, int amplifier, boolean ambient, boolean showParticles, @Nullable LivingEntity attacker) {
            super((MobEffect)Instances.BLEEDING, duration, amplifier, ambient, showParticles);
            this.damageSourceEntity = attacker;
        }
    }

    public static class EntityBleedingDamageSource
    extends DamageSource {
        @Nullable
        protected final Entity damageSourceEntity;

        public EntityBleedingDamageSource(@Nullable Entity damageSourceEntity) {
            super(Instances.BLEEDING_SOURCE.f_19326_);
            this.m_19380_();
            this.damageSourceEntity = damageSourceEntity;
        }

        @Nullable
        public Entity m_7640_() {
            return null;
        }

        @Nullable
        public Entity m_7639_() {
            return this.damageSourceEntity;
        }
    }
}

