/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.effects;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.entities.ParasiteEntity;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.effects.EffectHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class InfestedEffect
extends MobEffect {
    protected final ConfigGroup effectGroup;
    protected final DurationConfig duration;
    protected final DoubleConfig damage;
    protected final IntegerConfig maximumAmplifier;
    protected final DurationConfig damageCooldown;

    public InfestedEffect() {
        super(MobEffectCategory.HARMFUL, -15329770);
        String durationComment = "Duration of this effect whenever it is applied by Parasite. (in seconds)";
        this.duration = new DurationConfig("duration", durationComment, false, 6.0, 1.0, 120.0);
        String damageComment = "Damage dealt after this effect expires and every cooldown ticks. (per level) (1.0 = half a heart)";
        this.damage = new DurationConfig("damage", damageComment, false, 1.0, 0.0, 20.0);
        String amplifierComment = "Maximum amplifier that can be applied by Parasite.";
        this.maximumAmplifier = new IntegerConfig("maximum_amplifier", amplifierComment, false, 4, 0, 100);
        String cooldownComment = "Cooldown between attacking the entity. (in seconds)";
        this.damageCooldown = new DurationConfig("damage_cooldown", cooldownComment, false, 1.5, 0.1, 10.0);
        this.effectGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("Infested", "Infested potion effect."));
        this.effectGroup.addConfigs(new IConfig[]{this.duration, this.damage, this.maximumAmplifier, this.damageCooldown});
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        this.damageEntity(amplifier, entity);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % this.damageCooldown.getDuration() == 0;
    }

    @SubscribeEvent
    public static void onEffectExpired(PotionEvent.PotionExpiryEvent event) {
        MobEffectInstance effectInstance = event.getPotionEffect();
        LivingEntity target = event.getEntityLiving();
        InfestedEffect infestedEffect = Instances.INFESTED;
        if (effectInstance == null || !((Object)((Object)infestedEffect)).equals(effectInstance.m_19544_()) || !(target.f_19853_ instanceof ServerLevel)) {
            return;
        }
        infestedEffect.spawnParasites(effectInstance.m_19564_(), target, (ServerLevel)target.f_19853_);
        infestedEffect.damageEntity(effectInstance.m_19564_(), target);
    }

    public void applyTo(LivingEntity target) {
        MobEffectInstance currentEffect = target.m_21124_((MobEffect)this);
        int amplifier = currentEffect != null ? Math.min(currentEffect.m_19564_() + 1, this.maximumAmplifier.get()) : 0;
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (MobEffect)this, (int)this.duration.getDuration(), (int)amplifier);
    }

    public boolean canBeAppliedTo(LivingEntity target) {
        MobEffectInstance currentEffect = target.m_21124_((MobEffect)this);
        return currentEffect == null || currentEffect.m_19564_() < this.maximumAmplifier.get();
    }

    public void spawnParasites(int effectAmplifier, LivingEntity target, ServerLevel world) {
        BlockPos targetPosition = target.m_142538_();
        for (int i = 0; i < effectAmplifier + 2; ++i) {
            Vec3 offset = Random.getRandomVector3d((double)-2.5, (double)2.5, (double)0.0, (double)0.0, (double)-2.5, (double)2.5);
            BlockPos parasitePosition = targetPosition.m_142022_(offset.f_82479_, 0.0, offset.f_82481_);
            Entity entity = ParasiteEntity.type.m_20592_(world, null, null, parasitePosition, MobSpawnType.EVENT, true, true);
            if (!(entity instanceof ParasiteEntity)) continue;
            ParasiteEntity parasite = (ParasiteEntity)entity;
            parasite.m_6710_(target);
            ParasiteEntity.spawnEffects(world, parasitePosition);
        }
    }

    protected void damageEntity(int amplifier, LivingEntity target) {
        target.m_6469_(Instances.INFESTED_SOURCE, (float)((double)(amplifier + 1) * this.damage.get()));
    }
}

