/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.entities;

import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.PacketHandler;
import com.majruszs_difficulty.features.undead_army.UndeadArmy;
import com.majruszs_difficulty.goals.TankAttackGoal;
import com.mlib.CommonHelper;
import com.mlib.MajruszLibrary;
import com.mlib.TimeConverter;
import com.mlib.network.message.EntityMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class TankEntity
extends Monster {
    public static final EntityType<TankEntity> type;
    protected static final int SPECIAL_ATTACK_DURATION;
    protected static final int NORMAL_ATTACK_DURATION;
    public boolean isLeftHandAttack;
    private int specialAttackTicksLeft;
    private int normalAttackTicksLeft;

    public TankEntity(EntityType<? extends TankEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 17;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new TankAttackGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected int m_6552_(Player player) {
        return super.m_6552_(player) + MajruszLibrary.RANDOM.nextInt(17);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.35f;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), volume * 1.25f, pitch * 0.75f);
        }
    }

    public void m_8107_() {
        if (this.m_21527_() && !UndeadArmy.doesEntityBelongToUndeadArmy((LivingEntity)this)) {
            this.m_20254_(8);
        }
        super.m_8107_();
    }

    public static AttributeSupplier getAttributeMap() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 140.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_(Attributes.f_22278_, 0.75).m_22265_();
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingUpdateEvent event) {
        TankEntity tank = (TankEntity)((Object)CommonHelper.castIfPossible(TankEntity.class, (Object)event.getEntityLiving()));
        if (tank != null) {
            tank.specialAttackTicksLeft = Math.max(tank.specialAttackTicksLeft - 1, 0);
            tank.normalAttackTicksLeft = Math.max(tank.normalAttackTicksLeft - 1, 0);
        }
    }

    public void useAttack(AttackType attackType) {
        switch (attackType) {
            case NORMAL: {
                this.normalAttackTicksLeft = NORMAL_ATTACK_DURATION;
                break;
            }
            case SPECIAL: {
                this.specialAttackTicksLeft = SPECIAL_ATTACK_DURATION;
            }
        }
        this.isLeftHandAttack = MajruszLibrary.RANDOM.nextBoolean();
        if (this.f_19853_ instanceof ServerLevel) {
            PacketHandler.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)new TankAttackMessage((Entity)this, attackType));
        }
    }

    public boolean isAttacking() {
        return this.isAttacking(AttackType.NORMAL) || this.isAttacking(AttackType.SPECIAL);
    }

    public boolean isAttacking(AttackType attackType) {
        return switch (attackType) {
            default -> throw new IncompatibleClassChangeError();
            case AttackType.NORMAL -> {
                if (this.normalAttackTicksLeft > 0) {
                    yield true;
                }
                yield false;
            }
            case AttackType.SPECIAL -> this.specialAttackTicksLeft > 0;
        };
    }

    public boolean isAttackLastTick() {
        return this.specialAttackTicksLeft == 1 || this.normalAttackTicksLeft == 1;
    }

    public float getAttackDurationRatioLeft() {
        float ratio = this.specialAttackTicksLeft > this.normalAttackTicksLeft ? (float)this.specialAttackTicksLeft / (float)SPECIAL_ATTACK_DURATION : (float)this.normalAttackTicksLeft / (float)NORMAL_ATTACK_DURATION;
        return 1.0f - Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f);
    }

    static {
        SPECIAL_ATTACK_DURATION = TimeConverter.secondsToTicks((double)0.9);
        NORMAL_ATTACK_DURATION = TimeConverter.secondsToTicks((double)0.6);
        type = EntityType.Builder.m_20704_(TankEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.1f, 2.7f).m_20712_(MajruszsDifficulty.getLocation("tank").toString());
    }

    public static enum AttackType {
        NORMAL,
        SPECIAL;

    }

    public static class TankAttackMessage
    extends EntityMessage {
        protected final AttackType attackType;

        public TankAttackMessage(Entity entity, AttackType attackType) {
            super(entity);
            this.attackType = attackType;
        }

        public TankAttackMessage(FriendlyByteBuf buffer) {
            super(buffer);
            this.attackType = (AttackType)buffer.m_130066_(AttackType.class);
        }

        public void encode(FriendlyByteBuf buffer) {
            super.encode(buffer);
            buffer.m_130068_((Enum)this.attackType);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void receiveMessage(NetworkEvent.Context context) {
            TankEntity tank;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (tank = (TankEntity)((Object)CommonHelper.castIfPossible(TankEntity.class, (Object)level.m_6815_(this.id)))) != null) {
                tank.useAttack(this.attackType);
            }
        }
    }
}

