/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class IncreaseGameDifficulty {
    @SubscribeEvent
    public static void onChangingDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IncreaseGameDifficulty gameDifficulty = Instances.INCREASE_GAME_DIFFICULTY;
        Player player = event.getPlayer();
        switch (GameState.getCurrentMode()) {
            case NORMAL: {
                gameDifficulty.handleDimensionExpertMode(player, (ResourceKey<Level>)event.getTo());
                break;
            }
            case EXPERT: {
                gameDifficulty.handleDimensionMasterMode(player, (ResourceKey<Level>)event.getTo());
            }
        }
    }

    @SubscribeEvent
    public static void onKillingEntity(LivingDeathEvent event) {
        IncreaseGameDifficulty gameDifficulty = Instances.INCREASE_GAME_DIFFICULTY;
        LivingEntity entity = event.getEntityLiving();
        switch (GameState.getCurrentMode()) {
            case NORMAL: {
                gameDifficulty.handleKillingEntityExpertMode(entity);
                break;
            }
            case EXPERT: {
                gameDifficulty.handleKillingEntityMasterMode(entity);
            }
        }
    }

    protected void handleDimensionExpertMode(Player player, ResourceKey<Level> dimension) {
        if (!Instances.GAME_STATE_CONFIG.shouldDimensionStartExpertMode(dimension.m_135782_())) {
            return;
        }
        this.startExpertMode(player.m_20194_());
    }

    protected void handleDimensionMasterMode(Player player, ResourceKey<Level> dimension) {
        if (!Instances.GAME_STATE_CONFIG.shouldDimensionStartMasterMode(dimension.m_135782_())) {
            return;
        }
        this.startMasterMode(player.m_20194_());
    }

    protected void handleKillingEntityExpertMode(LivingEntity entity) {
        EntityType entityType = entity.m_6095_();
        if (!Instances.GAME_STATE_CONFIG.shouldKillingEntityStartExpertMode(entityType.getRegistryName())) {
            return;
        }
        this.startExpertMode(entity.m_20194_());
    }

    protected void handleKillingEntityMasterMode(LivingEntity entity) {
        EntityType entityType = entity.m_6095_();
        if (!Instances.GAME_STATE_CONFIG.shouldKillingEntityStartMasterMode(entityType.getRegistryName())) {
            return;
        }
        this.startMasterMode(entity.m_20194_());
    }

    protected void startExpertMode(@Nullable MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        GameState.changeModeWithAdvancement(GameState.State.EXPERT, minecraftServer);
        this.sendMessageToAllPlayers(minecraftServer.m_6846_(), "majruszs_difficulty.on_expert_mode_start", GameState.EXPERT_MODE_COLOR);
    }

    protected void startMasterMode(@Nullable MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        GameState.changeModeWithAdvancement(GameState.State.MASTER, minecraftServer);
        this.sendMessageToAllPlayers(minecraftServer.m_6846_(), "majruszs_difficulty.on_master_mode_start", GameState.MASTER_MODE_COLOR);
    }

    protected void sendMessageToAllPlayers(PlayerList playerList, String translationKey, ChatFormatting textColor) {
        for (Player player : playerList.m_11314_()) {
            TranslatableComponent message = new TranslatableComponent(translationKey);
            message.m_130944_(new ChatFormatting[]{textColor, ChatFormatting.BOLD});
            player.m_5661_((Component)message, false);
        }
    }
}

