/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.mlib.LevelHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnDisabler {
    @SubscribeEvent
    public static void disableSpawns(LivingSpawnEvent.CheckSpawn event) {
        if (SpawnDisabler.shouldEntitySpawnBeDisabled((Entity)event.getEntityLiving())) {
            event.setResult(Event.Result.DENY);
        }
    }

    protected static boolean shouldEntitySpawnBeDisabled(Entity entity) {
        ResourceLocation entityKey = Registry.f_122826_.m_7981_((Object)entity.m_6095_());
        StringListConfig forbiddenMobsConfig = Instances.SPAWN_DISABLER_CONFIG.getCurrentForbiddenList();
        return forbiddenMobsConfig.contains(entityKey.toString()) || entity instanceof Illusioner && SpawnDisabler.isVillageNearby(entity);
    }

    private static boolean isVillageNearby(Entity entity) {
        if (!(entity.f_19853_ instanceof ServerLevel) || !LevelHelper.isEntityIn((Entity)entity, (ResourceKey)Level.f_46428_)) {
            return false;
        }
        ServerLevel world = (ServerLevel)entity.f_19853_;
        return world.m_8717_(StructureFeature.f_67028_, entity.m_142538_(), 10000, false) != null;
    }

    public static class Config {
        public final ConfigGroup configGroup;
        public final StringListConfig forbiddenInNormal;
        public final StringListConfig forbiddenInExpert;
        public final StringListConfig forbiddenInMaster;

        public Config() {
            String normalComment = "List of entities that cannot spawn in Normal Mode.";
            this.forbiddenInNormal = new StringListConfig("forbidden_normal", normalComment, false, new String[]{"majruszs_difficulty:giant", "minecraft:illusioner", "majruszs_difficulty:elite_skeleton", "majruszs_difficulty:parasite", "majruszs_difficulty:tank"});
            String expertComment = "List of entities that cannot spawn in Expert Mode.";
            this.forbiddenInExpert = new StringListConfig("forbidden_expert", expertComment, false, new String[]{"majruszs_difficulty:parasite"});
            String masterComment = "List of entities that cannot spawn in Master Mode.";
            this.forbiddenInMaster = new StringListConfig("forbidden_master", masterComment, false, new String[0]);
            String groupComment = "Disables natural spawning of given entities depending on current game progress. (entities can still spawn in structures though!)";
            this.configGroup = MajruszsDifficulty.CONFIG_HANDLER.addConfigGroup(new ConfigGroup("SpawnDisabler", groupComment));
            this.configGroup.addConfigs(new IConfig[]{this.forbiddenInNormal, this.forbiddenInExpert, this.forbiddenInMaster});
        }

        public StringListConfig getCurrentForbiddenList() {
            return GameState.getValueDependingOnCurrentGameState(this.forbiddenInNormal, this.forbiddenInExpert, this.forbiddenInMaster);
        }
    }
}

