/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.majruszs_difficulty.features.undead_army.UndeadArmy;
import com.majruszs_difficulty.goals.FollowGroupLeaderGoal;
import com.majruszs_difficulty.goals.TargetAsLeaderGoal;
import com.mlib.MajruszLibrary;
import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public abstract class SpawnEnemyGroupBase
extends OnEnemyToBeSpawnedBase {
    private static final String SIDEKICK_TAG = "MajruszsDifficultySidekick";
    protected final int minimumAmountOfChildren;
    protected final int maximumAmountOfChildren;
    protected final Item[] leaderArmor;

    public SpawnEnemyGroupBase(String configName, String configComment, GameState.State minimumState, boolean shouldChanceBeMultipliedByCRD, int minimumAmountOfChildren, int maximumAmountOfChildren, Item[] leaderArmor) {
        super(configName, configComment, 0.25, minimumState, shouldChanceBeMultipliedByCRD);
        this.minimumAmountOfChildren = minimumAmountOfChildren;
        this.maximumAmountOfChildren = maximumAmountOfChildren;
        this.leaderArmor = leaderArmor;
    }

    @Override
    public void onExecute(LivingEntity entity, ServerLevel world) {
        int childrenAmount = this.minimumAmountOfChildren + MajruszLibrary.RANDOM.nextInt(this.maximumAmountOfChildren - this.minimumAmountOfChildren + 1);
        if (this.isSidekick(entity)) {
            return;
        }
        if (this.leaderArmor != null) {
            this.giveArmorToLeader(entity);
        }
        this.spawnChildren(childrenAmount, entity, world);
    }

    protected abstract PathfinderMob spawnChild(ServerLevel var1);

    protected ItemStack generateWeaponForChild() {
        return null;
    }

    protected void markAsSidekick(LivingEntity entity) {
        CompoundTag data = entity.getPersistentData();
        data.m_128379_(SIDEKICK_TAG, true);
    }

    protected boolean isSidekick(LivingEntity entity) {
        CompoundTag data = entity.getPersistentData();
        return data.m_128441_(SIDEKICK_TAG) && data.m_128471_(SIDEKICK_TAG);
    }

    private void giveArmorToLeader(LivingEntity leader) {
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty(leader);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Item item : this.leaderArmor) {
            itemStacks.add(ItemHelper.damageAndEnchantItem((ItemStack)new ItemStack((ItemLike)item), (double)clampedRegionalDifficulty, (boolean)true, (double)0.5));
        }
        leader.m_8061_(EquipmentSlot.FEET, (ItemStack)itemStacks.get(0));
        leader.m_8061_(EquipmentSlot.LEGS, (ItemStack)itemStacks.get(1));
        leader.m_8061_(EquipmentSlot.CHEST, (ItemStack)itemStacks.get(2));
        leader.m_8061_(EquipmentSlot.HEAD, (ItemStack)itemStacks.get(3));
    }

    private void giveWeaponTo(LivingEntity child) {
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty(child);
        ItemStack weapon = this.generateWeaponForChild();
        if (weapon != null) {
            child.m_8061_(EquipmentSlot.MAINHAND, ItemHelper.damageAndEnchantItem((ItemStack)weapon, (double)clampedRegionalDifficulty, (boolean)true, (double)0.5));
        }
    }

    private void setupGoals(PathfinderMob leader, PathfinderMob follower, int goalPriority, int targetPriority) {
        follower.f_21345_.m_25352_(goalPriority, (Goal)new FollowGroupLeaderGoal((Mob)follower, (Mob)leader, 1.0, 6.0f, 5.0f));
        follower.f_21346_.m_25352_(targetPriority, (Goal)new TargetAsLeaderGoal(follower, leader));
    }

    private void spawnChildren(int amount, LivingEntity leader, ServerLevel world) {
        Vec3 spawnPosition = leader.m_20182_();
        if (!(leader instanceof PathfinderMob)) {
            return;
        }
        for (int childID = 0; childID < amount; ++childID) {
            PathfinderMob child = this.spawnChild(world);
            double x = spawnPosition.f_82479_ - 3.0 + (double)MajruszLibrary.RANDOM.nextInt(7);
            double y = spawnPosition.f_82480_ + 0.5;
            double z = spawnPosition.f_82481_ - 3.0 + (double)MajruszLibrary.RANDOM.nextInt(7);
            child.m_6034_(x, y, z);
            this.setupGoals((PathfinderMob)leader, child, 9, 9);
            this.giveWeaponTo((LivingEntity)child);
            this.markAsSidekick((LivingEntity)child);
            world.m_7967_((Entity)child);
        }
    }

    protected static boolean notUndeadArmyMob(LivingEntity entity) {
        return !UndeadArmy.doesEntityBelongToUndeadArmy(entity);
    }

    protected static class Armors {
        public static Item[] leather = new Item[]{Items.f_42463_, Items.f_42462_, Items.f_42408_, Items.f_42407_};
        public static Item[] iron = new Item[]{Items.f_42471_, Items.f_42470_, Items.f_42469_, Items.f_42468_};
        public static Item[] golden = new Item[]{Items.f_42479_, Items.f_42478_, Items.f_42477_, Items.f_42476_};

        protected Armors() {
        }
    }
}

