/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.special;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.config.GameStateIntegerConfig;
import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.majruszs_difficulty.features.ChanceFeatureBase;
import com.mlib.MajruszLibrary;
import com.mlib.config.IConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SplitCreeperToCreeperlings
extends ChanceFeatureBase {
    private static final String CONFIG_NAME = "SplitCreeper";
    private static final String CONFIG_COMMENT = "Creepers after the explosion have a chance to spawn Creeperlings.";
    protected final GameStateIntegerConfig creeperlingsAmount;

    public SplitCreeperToCreeperlings() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.666, GameState.State.NORMAL, false);
        String creeperlingComment = "Maximum amount of Creeperlings.";
        this.creeperlingsAmount = new GameStateIntegerConfig("maximum_creeperlings", creeperlingComment, 1, 3, 5, 0, 10);
        this.featureGroup.addConfig((IConfig)this.creeperlingsAmount);
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (!SplitCreeperToCreeperlings.isValid(event.getExplosion(), event.getWorld())) {
            return;
        }
        SplitCreeperToCreeperlings splitCreeperToCreeperlings = Instances.SPLIT_CREEPER_TO_CREEPERLINGS;
        Explosion explosion = event.getExplosion();
        Creeper creeper = (Creeper)explosion.getExploder();
        ServerLevel world = (ServerLevel)event.getWorld();
        int amountOfCreeperlings = splitCreeperToCreeperlings.getRandomAmountOfCreeperlings();
        if (creeper == null) {
            return;
        }
        for (int i = 0; i < amountOfCreeperlings; ++i) {
            BlockPos position = SplitCreeperToCreeperlings.getNearbyPosition(creeper);
            CreeperlingEntity creeperling = (CreeperlingEntity)CreeperlingEntity.type.m_20600_(world, null, null, null, position, MobSpawnType.SPAWNER, true, true);
            if (creeperling == null) continue;
            creeperling.m_6710_(creeper.m_5448_());
        }
    }

    private static BlockPos getNearbyPosition(Creeper creeper) {
        BlockPos position = creeper.m_142538_();
        double x = (double)position.m_123341_() + MajruszLibrary.RANDOM.nextDouble() - 0.5;
        double y = (double)position.m_123342_() + MajruszLibrary.RANDOM.nextDouble() - 0.5;
        double z = (double)position.m_123343_() + MajruszLibrary.RANDOM.nextDouble() - 0.5;
        return new BlockPos(x, y, z);
    }

    private static boolean isValid(Explosion explosion, Level world) {
        SplitCreeperToCreeperlings splitCreeperToCreeperlings = Instances.SPLIT_CREEPER_TO_CREEPERLINGS;
        boolean isCausedByCreeper = explosion.getExploder() instanceof Creeper && !(explosion.getExploder() instanceof CreeperlingEntity);
        boolean isServerLevel = world instanceof ServerLevel;
        return isCausedByCreeper && isServerLevel && splitCreeperToCreeperlings.isEnabled() && splitCreeperToCreeperlings.tryChance(null);
    }

    protected int getRandomAmountOfCreeperlings() {
        return MajruszLibrary.RANDOM.nextInt(this.creeperlingsAmount.getCurrentGameStateValue() + 1);
    }
}

