/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.special;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.entities.CreeperlingEntity;
import com.majruszs_difficulty.features.ChanceFeatureBase;
import com.majruszs_difficulty.features.FeatureBase;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import com.mlib.events.ExplosionSizeEvent;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class StrongerExplosions {
    private final BiggerSize biggerSize = new BiggerSize();
    private final CausingFire causingFire = new CausingFire();

    @SubscribeEvent
    public static void onExplosion(ExplosionSizeEvent event) {
        LivingEntity causer;
        LivingEntity livingEntity = causer = event.explosion.getExploder() instanceof LivingEntity ? (LivingEntity)event.explosion.getExploder() : event.explosion.m_46079_();
        if (causer == null) {
            causer = StrongerExplosions.getNearestEntity(event.explosion, event.level);
        }
        if (Instances.STRONGER_EXPLOSIONS.biggerSize.isEnabled()) {
            event.size *= Instances.STRONGER_EXPLOSIONS.biggerSize.getRadius(causer);
        }
        if (!(causer instanceof CreeperlingEntity) && Instances.STRONGER_EXPLOSIONS.causingFire.isEnabled() && Random.tryChance((double)Instances.STRONGER_EXPLOSIONS.causingFire.calculateChance(causer))) {
            event.causesFire = true;
        }
    }

    @Nullable
    private static LivingEntity getNearestEntity(Explosion explosion, Level world) {
        Vec3 position = explosion.getPosition();
        double offset = 50.0;
        AABB axisAlignedBB = new AABB(position.f_82479_ - offset, position.f_82480_ - offset, position.f_82481_ - offset, position.f_82479_ + offset, position.f_82480_ + offset, position.f_82481_ + offset);
        Iterator iterator = world.m_45976_(LivingEntity.class, axisAlignedBB).iterator();
        if (iterator.hasNext()) {
            LivingEntity entity = (LivingEntity)iterator.next();
            return entity;
        }
        return null;
    }

    public static class BiggerSize
    extends FeatureBase {
        private static final String CONFIG_NAME = "BiggerExplosionSize";
        private static final String CONFIG_COMMENT = "Increases size of all explosions. (creeper, tnt, ghast ball etc.)";
        protected final DoubleConfig maximumMultiplier;

        public BiggerSize() {
            super(CONFIG_NAME, CONFIG_COMMENT, GameState.State.NORMAL);
            String multiplierComment = "Explosion radius multiplier. (this value is scaled by Clamped Regional Difficulty)";
            this.maximumMultiplier = new DoubleConfig("maximum_multiplier", multiplierComment, false, 1.2599, 1.0, 10.0);
            this.featureGroup.addConfig((IConfig)this.maximumMultiplier);
        }

        public float getRadius(LivingEntity entity) {
            double factor = this.maximumMultiplier.get() - 1.0;
            double difficultyFactor = entity != null ? GameState.getRegionalDifficulty(entity) : 0.5;
            return (float)(1.0 + factor * difficultyFactor);
        }
    }

    public static class CausingFire
    extends ChanceFeatureBase {
        private static final String CONFIG_NAME = "ExplosionCausingFire";
        private static final String CONFIG_COMMENT = "Makes all explosions leave fire.";

        public CausingFire() {
            super(CONFIG_NAME, CONFIG_COMMENT, 1.0, GameState.State.EXPERT, true);
        }
    }
}

