/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.treasure_bag;

import com.majruszs_difficulty.items.TreasureBagItem;
import com.mlib.LevelHelper;
import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TreasureBagManager {
    public static final String TREASURE_BAG_TAG = "TreasureBagPlayersToReward";
    public static final String PLAYER_TAG = "TreasureBagPlayerUUID";
    private static final List<Register> registers = new ArrayList<Register>();

    public static void addTreasureBagTo(EntityType<?> entityType, TreasureBagItem treasureBag, boolean replaceLoot) {
        registers.add(new Register(entityType, treasureBag, replaceLoot));
    }

    public static boolean hasTreasureBag(EntityType<?> entityType) {
        for (Register register : registers) {
            if (!register.entityType.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldReplaceLoot(EntityType<?> entityType) {
        for (Register register : registers) {
            if (!register.entityType.equals(entityType)) continue;
            return register.shouldReplaceLoot;
        }
        return false;
    }

    @Nullable
    public static TreasureBagItem getTreasureBag(EntityType<?> entityType) {
        for (Register register : registers) {
            if (!register.entityType.equals(entityType)) continue;
            return register.treasureBag;
        }
        return null;
    }

    public static boolean rewardAllPlayers(LivingEntity killedEntity) {
        CompoundTag data = killedEntity.getPersistentData();
        ServerLevel world = LevelHelper.getServerLevelFromEntity((Entity)killedEntity);
        if (data.m_128441_(TREASURE_BAG_TAG) && world != null) {
            ListTag listNBT = data.m_128437_(TREASURE_BAG_TAG, 10);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag playerNBT = listNBT.m_128728_(i);
                String playerUUID = playerNBT.m_128461_(PLAYER_TAG);
                Player player = world.m_46003_(UUID.fromString(playerUUID));
                if (player == null) continue;
                ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((ItemLike)TreasureBagManager.getTreasureBag(killedEntity.m_6095_())), (Player)player, (ServerLevel)world);
            }
            int amountOfPlayersRewarded = listNBT.size();
            listNBT.clear();
            return amountOfPlayersRewarded > 0;
        }
        return false;
    }

    static class Register {
        public final EntityType<?> entityType;
        public final TreasureBagItem treasureBag;
        public final boolean shouldReplaceLoot;

        public Register(EntityType<?> entityType, TreasureBagItem treasureBag, boolean replaceLoot) {
            this.entityType = entityType;
            this.treasureBag = treasureBag;
            this.shouldReplaceLoot = replaceLoot;
        }
    }
}

