/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.features.undead_army.Direction;
import com.majruszs_difficulty.features.undead_army.UndeadArmy;
import com.majruszs_difficulty.features.undead_army.UndeadArmyConfig;
import com.mlib.LevelHelper;
import com.mlib.MajruszLibrary;
import com.mlib.TimeConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class UndeadArmyManager
extends SavedData {
    public static final String DATA_NAME = "undead_army";
    public static final double MAXIMUM_DISTANCE_TO_ARMY = 12000.0;
    private final List<UndeadArmy> undeadArmies = new ArrayList<UndeadArmy>();
    private final List<UndeadArmyToBeSpawned> undeadArmiesToBeSpawned = new ArrayList<UndeadArmyToBeSpawned>();
    private ServerLevel level;
    private long ticksActive = 0L;

    public UndeadArmyManager(ServerLevel world) {
        this.level = world;
    }

    public CompoundTag m_7176_(CompoundTag compoundNBT) {
        compoundNBT.m_128356_("TicksActive", this.ticksActive);
        ListTag listNBT = new ListTag();
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            CompoundTag nbt = new CompoundTag();
            undeadArmy.write(nbt);
            listNBT.add((Object)nbt);
        }
        compoundNBT.m_128365_("Armies", (Tag)listNBT);
        return compoundNBT;
    }

    public static UndeadArmyManager load(CompoundTag nbt, ServerLevel level) {
        UndeadArmyManager armyManager = new UndeadArmyManager(level);
        armyManager.ticksActive = nbt.m_128454_("TicksActive");
        ListTag listNBT = nbt.m_128437_("Armies", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            armyManager.undeadArmies.add(new UndeadArmy(armyManager.level, listNBT.m_128728_(i)));
        }
        return armyManager;
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.ServerTickEvent event) {
        if (event.side.isClient() || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (RegistryHandler.UNDEAD_ARMY_MANAGER != null) {
            RegistryHandler.UNDEAD_ARMY_MANAGER.tick();
        }
    }

    public void updateWorld(ServerLevel world) {
        this.level = world;
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            undeadArmy.updateWorld(world);
        }
    }

    public boolean tryToSpawn(Player player) {
        return LevelHelper.isEntityIn((Entity)player, (ResourceKey)Level.f_46428_) && this.tryToSpawn(this.getAttackPosition(player));
    }

    public boolean tryToSpawn(BlockPos attackPosition) {
        return this.tryToSpawn(attackPosition, Optional.empty());
    }

    public boolean tryToSpawn(BlockPos attackPosition, Optional<Direction> optionalDirection) {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        if (this.findNearestUndeadArmy(attackPosition) != null || this.isArmySpawningHere(attackPosition) || config.isUndeadArmyDisabled()) {
            return false;
        }
        Direction direction = optionalDirection.orElse(Direction.getRandom());
        this.undeadArmiesToBeSpawned.add(new UndeadArmyToBeSpawned(TimeConverter.secondsToTicks((double)6.5), attackPosition, direction));
        this.level.m_5594_(null, attackPosition, Instances.Sounds.UNDEAD_ARMY_APPROACHING, SoundSource.AMBIENT, 0.25f, 1.0f);
        MajruszLibrary.LOGGER.info("Undead Army started at " + attackPosition + "!");
        return true;
    }

    public void tick() {
        ++this.ticksActive;
        this.tickArmiesToBeSpawned();
        this.tickArmies();
        if (this.ticksActive % 200L == 0L) {
            this.m_77762_();
        }
    }

    @Nullable
    public UndeadArmy findNearestUndeadArmy(BlockPos position) {
        UndeadArmy nearestArmy = null;
        double minimumDistance = 12000.0;
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            double distanceToUndeadArmy = undeadArmy.getAttackPosition().m_123331_((Vec3i)position);
            if (!undeadArmy.isActive() || !(distanceToUndeadArmy < minimumDistance)) continue;
            nearestArmy = undeadArmy;
            minimumDistance = distanceToUndeadArmy;
        }
        return nearestArmy;
    }

    public boolean isArmySpawningHere(BlockPos position) {
        for (UndeadArmyToBeSpawned undeadArmyToBeSpawned : this.undeadArmiesToBeSpawned) {
            if (!(undeadArmyToBeSpawned.position.m_123331_((Vec3i)position) < 12000.0)) continue;
            return true;
        }
        return false;
    }

    public void updateUndeadAIGoals() {
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            undeadArmy.updateNearbyUndeadAIGoals();
        }
    }

    private void tickArmiesToBeSpawned() {
        for (UndeadArmyToBeSpawned undeadArmyToBeSpawned2 : this.undeadArmiesToBeSpawned) {
            --undeadArmyToBeSpawned2.ticksToSpawn;
            if (undeadArmyToBeSpawned2.ticksToSpawn != 0) continue;
            this.undeadArmies.add(new UndeadArmy(this.level, undeadArmyToBeSpawned2.position, undeadArmyToBeSpawned2.direction));
        }
        this.undeadArmiesToBeSpawned.removeIf(undeadArmyToBeSpawned -> undeadArmyToBeSpawned.ticksToSpawn == 0);
    }

    private void tickArmies() {
        for (UndeadArmy undeadArmy2 : this.undeadArmies) {
            undeadArmy2.tick();
        }
        if (this.ticksActive % 20L == 0L) {
            this.undeadArmies.removeIf(undeadArmy -> !undeadArmy.isActive());
        }
    }

    private BlockPos getAttackPosition(Player player) {
        BlockPos playerPosition = player.m_142538_();
        int x = playerPosition.m_123341_();
        int y = playerPosition.m_123342_();
        int z = playerPosition.m_123343_();
        return new BlockPos(x, this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z), z);
    }

    public boolean doesEntityBelongToUndeadArmy(LivingEntity entity) {
        return UndeadArmy.doesEntityBelongToUndeadArmy(entity);
    }

    public static class UndeadArmyToBeSpawned {
        public int ticksToSpawn;
        public BlockPos position;
        public Direction direction;

        public UndeadArmyToBeSpawned(int ticksToSpawn, BlockPos position, Direction direction) {
            this.ticksToSpawn = ticksToSpawn;
            this.position = position;
            this.direction = direction;
        }
    }
}

