/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.when_damaged.ChanceWhenDamagedBase;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DrownedLightningOnAttack
extends ChanceWhenDamagedBase {
    private static final String CONFIG_NAME = "DrownedLightning";
    private static final String CONFIG_COMMENT = "Drowned attacks with trident spawn lightning bolt.";

    public DrownedLightningOnAttack() {
        super(CONFIG_NAME, CONFIG_COMMENT, 0.25, GameState.State.EXPERT, true);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        if (!this.tryChance(target)) {
            return;
        }
        ServerLevel world = (ServerLevel)target.f_19853_;
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
        if (lightningBolt == null) {
            return;
        }
        lightningBolt.m_20248_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        world.m_7967_((Entity)lightningBolt);
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        boolean isDrowned = attacker instanceof Drowned;
        ItemStack heldItemStack = attacker != null ? attacker.m_21205_() : null;
        boolean isDrownedHoldingTrident = isDrowned && heldItemStack.m_41720_() instanceof TridentItem;
        return isDrownedHoldingTrident && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

