/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedApplyEffectBase;
import javax.annotation.Nullable;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public abstract class WhenDamagedApplyStackableEffectBase
extends WhenDamagedApplyEffectBase {
    protected final boolean isAmplifierStackable;
    protected final boolean isDurationStackable;
    protected final int maximumAmplifier;
    protected final int maximumDurationInTicks;

    public WhenDamagedApplyStackableEffectBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds, GameState.State minimumState, boolean shouldBeMultipliedByCRD, MobEffect[] effects, boolean isAmplifierStackable, boolean isDurationStackable, int maximumAmplifier, int maximumDurationInTicks) {
        super(configName, configComment, defaultChance, defaultDurationInSeconds, minimumState, shouldBeMultipliedByCRD, effects);
        this.isAmplifierStackable = isAmplifierStackable;
        this.isDurationStackable = isDurationStackable;
        this.maximumAmplifier = maximumAmplifier;
        this.maximumDurationInTicks = maximumDurationInTicks;
    }

    public WhenDamagedApplyStackableEffectBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds, GameState.State minimumState, boolean shouldBeMultipliedByCRD, MobEffect effect, boolean isAmplifierStackable, boolean isDurationStackable, int maximumAmplifier, int maximumDurationInTicks) {
        this(configName, configComment, defaultChance, defaultDurationInSeconds, minimumState, shouldBeMultipliedByCRD, new MobEffect[]{effect}, isAmplifierStackable, isDurationStackable, maximumAmplifier, maximumDurationInTicks);
    }

    @Override
    protected void applyEffect(@Nullable LivingEntity attacker, LivingEntity target, MobEffect effect, Difficulty difficulty) {
        MobEffectInstance effectInstance;
        MobEffectInstance previousMobEffectInstance = target.m_21124_(effect);
        if (previousMobEffectInstance == null) {
            super.applyEffect(attacker, target, effect, difficulty);
            return;
        }
        int durationInTicks = this.getDurationInTicks(difficulty);
        if (this.isDurationStackable) {
            durationInTicks = Math.min(durationInTicks + previousMobEffectInstance.m_19557_(), this.maximumDurationInTicks);
        }
        int amplifier = this.getAmplifier(difficulty);
        if (this.isAmplifierStackable) {
            amplifier = Math.min(amplifier + previousMobEffectInstance.m_19564_() + 1, this.maximumAmplifier);
        }
        if (target.m_7301_(effectInstance = new MobEffectInstance(effect, durationInTicks, amplifier))) {
            target.m_7292_(effectInstance);
        }
    }
}

