/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.goals;

import com.majruszs_difficulty.entities.TankEntity;
import com.mlib.CommonHelper;
import com.mlib.Random;
import com.mlib.entities.EntityHelper;
import com.mlib.math.VectorHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TankAttackGoal
extends MeleeAttackGoal {
    private final TankEntity tank;
    private boolean hasAttacked = false;

    public TankAttackGoal(TankEntity tank) {
        super((PathfinderMob)tank, 1.0, true);
        this.tank = tank;
    }

    public void m_8037_() {
        super.m_8037_();
        this.tank.m_21561_(!this.tank.isAttacking() && this.m_25565_() < this.m_25566_() / 2);
    }

    protected void m_6739_(LivingEntity entity, double distance) {
        Vec3 tankPosition = new Vec3(this.f_25540_.m_20185_(), this.f_25540_.m_20227_(0.5), this.f_25540_.m_20189_());
        distance = VectorHelper.distance((Vec3)tankPosition, (Vec3)entity.m_20182_());
        if (distance <= this.m_6639_(entity) && this.m_25564_() && !this.tank.isAttacking()) {
            this.tank.useAttack(Random.tryChance((double)0.25) ? TankEntity.AttackType.SPECIAL : TankEntity.AttackType.NORMAL);
        } else if (!this.hasAttacked) {
            if (this.tank.isAttacking(TankEntity.AttackType.NORMAL) && this.tank.getAttackDurationRatioLeft() > 0.45f) {
                if (distance <= this.m_6639_(entity)) {
                    this.tank.m_7327_((Entity)entity);
                    this.tank.m_5496_(SoundEvents.f_12381_, 0.75f, 0.9f);
                }
            } else if (this.tank.isAttacking(TankEntity.AttackType.SPECIAL) && this.tank.getAttackDurationRatioLeft() > 0.55f) {
                this.hurtAllEntitiesInRange(entity);
                this.tank.m_5496_(SoundEvents.f_12381_, 0.75f, 0.9f);
            } else {
                return;
            }
            this.hasAttacked = true;
        } else if (this.tank.isAttackLastTick()) {
            this.m_25563_();
            this.hasAttacked = false;
        }
    }

    protected double m_6639_(LivingEntity entity) {
        return super.m_6639_(entity) * 0.6;
    }

    protected void hurtAllEntitiesInRange(LivingEntity target) {
        ServerLevel level = (ServerLevel)CommonHelper.castIfPossible(ServerLevel.class, (Object)this.tank.f_19853_);
        if (level == null) {
            return;
        }
        Vec3 position = this.getSpecialAttackPosition(this.tank.m_20182_(), target.m_20182_());
        Predicate<LivingEntity> notTankPredicate = entity -> !entity.equals((Object)this.tank);
        List entities = EntityHelper.getEntitiesInSphere(LivingEntity.class, (ServerLevel)level, (Vec3)position, (double)7.0, notTankPredicate);
        for (LivingEntity entity2 : entities) {
            this.tank.m_7327_((Entity)entity2);
        }
        this.spawnSpecialAttackEffects(level, position);
    }

    protected Vec3 getSpecialAttackPosition(Vec3 tankPosition, Vec3 targetPosition) {
        Vec3 normalizedOffset = VectorHelper.normalize((Vec3)VectorHelper.subtract((Vec3)targetPosition, (Vec3)tankPosition));
        return VectorHelper.add((Vec3)tankPosition, (Vec3)VectorHelper.multiply((Vec3)normalizedOffset, (Number)1.75));
    }

    protected void spawnSpecialAttackEffects(ServerLevel level, Vec3 position) {
        Optional<BlockState> blockState = Optional.ofNullable(this.getBlockStateBelowPosition(level, position));
        BlockParticleOption blockParticleOption = new BlockParticleOption(ParticleTypes.f_123794_, blockState.orElse(Blocks.f_50493_.m_49966_())).setPos(new BlockPos(position));
        level.m_8767_((ParticleOptions)blockParticleOption, position.f_82479_, position.f_82480_ + 0.25, position.f_82481_, 120, 1.0, 0.25, 1.0, 0.5);
    }

    @Nullable
    protected BlockState getBlockStateBelowPosition(ServerLevel level, Vec3 position) {
        for (int y = (int)position.f_82480_; y > 0; --y) {
            BlockState blockState = level.m_8055_(new BlockPos(position.f_82479_, (double)y, position.f_82481_));
            if (blockState.m_60795_()) continue;
            return blockState;
        }
        return null;
    }
}

